/*
 * sim800.h
 * A library for SeeedStudio seeeduino GPRS shield 
 *
 * Copyright (c) 2013 seeed technology inc.
 * Author        :   lawliet zou
 * Create Time   :   Dec 2013
 * Change Log    :
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/*
 * improved by semesin (http://www.semesin.com/project/)
 */

#ifndef __SIM800L_H__
#define __SIM800L_H__

#include "Arduino.h"
#include <SoftwareSerial.h>

#define UART_DEBUG

#ifdef UART_DEBUG
#define ERROR(x)            Serial.println(x)
#define DEBUG(x)            Serial.write(x);
#else
#define ERROR(x)
#define DEBUG(x)
#endif

#define errorOK 0
#define errorOtherOK -1
#define errorTimeout -2
#define errorResponse -3
#define errorNoSpace -4

#define newEventSMS 0
#define newEventCall 0xCA

#define DEFAULT_TIMEOUT     5000

/** SIM800 class.
 *  Used for SIM800 communication. attention that SIM800 module communicate with MCU in serial protocol
 */
class SIM800
{

	public:
		int _resetPin;
		Stream *serialSIM800;
		HardwareSerial *hwSerial;
		SoftwareSerial *swSerial;
		bool HardwareSerialMode;
    uint32_t _ip;
    char ip_string[20];
		String incomingBuffer;

		SIM800(HardwareSerial *serial, byte resetPin, uint32_t baudRate);
		SIM800(SoftwareSerial *serial, byte resetPin, uint32_t baudRate);

		void reset(void);
    int init(uint32_t baudrate);
		bool waitSIMReady();
		
		int readBuffer(char* buffer,int *length, unsigned int timeOut = DEFAULT_TIMEOUT);
		void sendCmd(const char* cmd);
		int sendATTest(void);
		int waitForResp(const char* resp, unsigned timeout);
		int sendCmdAndWaitForResp(const char* cmd, const char *resp, unsigned timeout);
		void serialDebug(void);
		void writeDebug(void);
		void SMSListDebug(void);

		byte checkEvent();

    int checkSIMStatus(void);
    int sendSMS(char* number, char* data);
    int readSMS(int Index, String *messageBuffer, String *numberBuffer);
    int deleteSMS(int index);

    int callUp(char* number);
    int answer(void);
    int join(const char  *apn = 0, const char *userName = 0, const char *passWord = 0);
    uint32_t str_to_ip(const char* str);
    char* getIPAddress();
    int networkCheck(void);
    int connectTCP(const char* ip, int port);
    int sendTCPData(char* data);
    int closeTCP(void);
    int shutTCP(void);

		private:
    
};

#endif