#ifndef PS2_h
#define PS2_h
#include "Arduino.h"


/*
  Purpose: Provides advanced access to PS2 keyboards
  Public class definitions

  See standard error codes for error code returns
 */
class PS2 {
  public:
  	/* This constructor does basically nothing. Please call the begin(int,int)
  	   method before using any other method of this class. 	 */
    PS2();

    /* Starts the keyboard "service" by registering the external interrupt.
       setting the pin modes correctly and driving those needed to high.
       Sets default LOCK status (LEDs) to passed in value or default of all off
       The best place to call this method is in the setup routine.    */
    void begin( uint8_t, uint8_t  );

    /* Returns number of codes available or 0 for none */
    uint8_t available();

    /* Returns the key last read from the keyboard.
       If there is no key available, 0 is returned.  */
    uint16_t read();
    uint16_t readCode();

    /* Returns the current status of Locks
        Use Macro to mask out bits from
        PS2_LOCK_NUM    PS2_LOCK_CAPS   PS2_LOCK_SCROLL */
    uint8_t getLock();

    /* Sets the current status of Locks and LEDs
       Use macro defines added together from
        PS2_LOCK_NUM    PS2_LOCK_CAPS   PS2_LOCK_SCROLL */
    void setLock( byte );

    /* Set library to not send break key codes
            1 = no break codes
            0 = send break codes  */
    void setNoBreak( uint8_t );

    /* Set library to not repeat make codes for CTRL, ALT, GUI, SHIFT
            1 = no repeat codes
            0 = send repeat codes  */
    void setNoRepeat( uint8_t );

    /* Resets keyboard when reset has completed
       keyboard sends AA - Pass or FC for fail
       Read from keyboard data buffer */
    void resetKey();

    /*  Get the current Scancode Set used in keyboard
        returned data in keyboard buffer read as keys */
    void getScanCodeSet( void );

    /*  Get the current Scancode Set used in keyboard
        returned data in keyboard buffer read as keys */
    void readID( void );

    /*  Send Echo command to keyboard
        returned data in keyboard buffer read as keys */
    void echo( void );

    /*  Send Typematic rate/delay command to keyboard
       First Parameter  rate is 0 - 0x1F (31)
                0 = 30 CPS
                0x1F = 2 CPS
                default in keyboard is 0xB (10.9 CPS)
       Second Parameter delay is 0 - 3 for 0.25s to 1s in 0.25 increments
         default in keyboard is 1 = 0.5 second delay
        Returned data in keyboard buffer read as keys */
    int typematic( uint8_t , uint8_t );
};
#endif
