/* Version V1.0.2
  PS2KeyTable.h - PS2 library keycode values to return values
  Copyright (c) 2007 Free Software Foundation.  All right reserved.
  Written by Paul Carpenter, PC Services <sales@pcserviceselectronics.co.uk>
  Created September 2014
  V1.0.2 Updated January 2016 - Paul Carpenter - add tested on Due and tidy ups for V1.5 Library Management
  
  PRIVATE to library

  Test History
    September 2014 Uno and Mega 2560 September 2014 using Arduino V1.6.0
    January 2016   Uno, Mega 2560 and Due using Arduino 1.6.7 and Due Board 
                    Manager V1.6.6

  Internal to library private tables
  (may disappear in updates do not rely on this file or definitions)

  This is for a LATIN style keyboard. Will support most keyboards even ones
  with multimedia keys or even 24 function keys.

  Definitions used for key codes from a PS2 keyboard, do not use in your
  code these are handled by the library.

  See PS2.h for codes returned from library and flag settings

  Two sets of tables

     Single Byte codes returned as key codes

     Two byte Codes preceded by E0 code returned as keycodes

  Same tables used for make and break decode

  Special cases are -

    PRTSCR that ignores one of the sequences (E0,12) as this is not always sent
    especially with modifier keys or some keyboards when typematic repeat comes on.

    PAUSE as this is an 8 byte sequence only one starting E1 so main code gets E1
    and waits for 7 more valid bytes to make the coding.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef PS2KeyTable_h
#define PS2KeyTable_h

/* Flags/bit masks for status bits in returned unsigned int value */
#define PS2_BREAK   0x8000
#define PS2_SHIFT   0x4000
#define PS2_CTRL    0x2000
#define PS2_CAPS    0x1000
#define PS2_ALT      0x800
#define PS2_ALT_GR   0x400
#define PS2_GUI      0x200
#define PS2_FUNCTION 0x100

/* General defines of communications codes */
/* Command or response */
#define PS2_KEY_RESEND   0xFE
#define PS2_KEY_ACK      0xFA
#define PS2_KEY_ECHO     0xEE
/* Responses */
#define PS2_KEY_BAT      0xAA
// Actually buffer overrun
#define PS2_KEY_OVERRUN  0xFF
// Below is general error code
#define PS2_KEY_ERROR    0xFC

/* Command parameters for functions */
/* LED codes OR together */
#define PS2_LOCK_SCROLL  0x01
#define PS2_LOCK_NUM     0x02
#define PS2_LOCK_CAPS    0x04
/* Only useful for very few keyboards */
#define PS2_LOCK_EXTRA   0x08

/* Returned keycode definitions */
/* Do NOT change these codings as you will break base
   functionality use PS2KeyMap for that and internationalisation */
#define PS2_KEY_NUM         0x01
#define PS2_KEY_SCROLL      0x02
#define PS2_KEY_CAPS        0x03
#define PS2_KEY_PRTSCR      0x04
#define PS2_KEY_PAUSE       0x05
#define PS2_KEY_L_SHIFT     0x06
#define PS2_KEY_R_SHIFT     0x07
#define PS2_KEY_L_CTRL      0X08
#define PS2_KEY_R_CTRL      0X09
#define PS2_KEY_L_ALT       0x0A
#define PS2_KEY_R_ALT       0x0B
/* Sometimes called windows key */
#define PS2_KEY_L_GUI       0x0C
#define PS2_KEY_R_GUI       0x0D
#define PS2_KEY_MENU        0x0E
/* Break is CTRL + PAUSE generated inside keyboard */
#define PS2_KEY_BREAK       0x0F
/* Generated by some keyboards by ALT and PRTSCR */
#define PS2_KEY_SYSRQ       0x10
#define PS2_KEY_HOME        0x11
#define PS2_KEY_END         0x12
#define PS2_KEY_PGUP        0x13
#define PS2_KEY_PGDN        0x14
#define PS2_KEY_L_ARROW     0x15
#define PS2_KEY_R_ARROW     0x16
#define PS2_KEY_UP_ARROW    0x17
#define PS2_KEY_DN_ARROW    0x18
#define PS2_KEY_INSERT      0x19
#define PS2_KEY_DELETE      0x1A
#define PS2_KEY_ESC         0x1B
#define PS2_KEY_BS          0x1C
#define PS2_KEY_TAB         0x1D
#define PS2_KEY_ENTER       0x1E
#define PS2_KEY_SPACE       0x1F
#define PS2_KEY_KP0         0x20
#define PS2_KEY_KP1         0x21
#define PS2_KEY_KP2         0x22
#define PS2_KEY_KP3         0x23
#define PS2_KEY_KP4         0x24
#define PS2_KEY_KP5         0x25
#define PS2_KEY_KP6         0x26
#define PS2_KEY_KP7         0x27
#define PS2_KEY_KP8         0x28
#define PS2_KEY_KP9         0x29
#define PS2_KEY_KP_DOT      0x2A
#define PS2_KEY_KP_ENTER    0x2B
#define PS2_KEY_KP_PLUS     0x2C
#define PS2_KEY_KP_MINUS    0x2D
#define PS2_KEY_KP_TIMES    0x2E
#define PS2_KEY_KP_DIV      0x2F
#define PS2_KEY_0           0X30
#define PS2_KEY_1           0X31
#define PS2_KEY_2           0X32
#define PS2_KEY_3           0X33
#define PS2_KEY_4           0X34
#define PS2_KEY_5           0X35
#define PS2_KEY_6           0X36
#define PS2_KEY_7           0X37
#define PS2_KEY_8           0X38
#define PS2_KEY_9           0X39
#define PS2_KEY_APOS        0X3A
#define PS2_KEY_COMMA       0X3B
#define PS2_KEY_MINUS       0X3C
#define PS2_KEY_DOT         0X3D
#define PS2_KEY_DIV         0X3E
/* Some Numeric keyboards have an '=' on right keypad */
#define PS2_KEY_KP_EQUAL    0x3F
/* Single quote or back quote */
#define PS2_KEY_SINGLE      0X40
#define PS2_KEY_A           0X41
#define PS2_KEY_B           0X42
#define PS2_KEY_C           0X43
#define PS2_KEY_D           0X44
#define PS2_KEY_E           0X45
#define PS2_KEY_F           0X46
#define PS2_KEY_G           0X47
#define PS2_KEY_H           0X48
#define PS2_KEY_I           0X49
#define PS2_KEY_J           0X4A
#define PS2_KEY_K           0X4B
#define PS2_KEY_L           0X4C
#define PS2_KEY_M           0X4D
#define PS2_KEY_N           0X4E
#define PS2_KEY_O           0X4F
#define PS2_KEY_P           0X50
#define PS2_KEY_Q           0X51
#define PS2_KEY_R           0X52
#define PS2_KEY_S           0X53
#define PS2_KEY_T           0X54
#define PS2_KEY_U           0X55
#define PS2_KEY_V           0X56
#define PS2_KEY_W           0X57
#define PS2_KEY_X           0X58
#define PS2_KEY_Y           0X59
#define PS2_KEY_Z           0X5A
#define PS2_KEY_SEMI        0X5B
#define PS2_KEY_BACK        0X5C
#define PS2_KEY_OPEN_SQ     0X5D
#define PS2_KEY_CLOSE_SQ    0X5E
#define PS2_KEY_EQUAL       0X5F
/* Some Numeric keypads have a comma key */
#define PS2_KEY_KP_COMMA    0x60
#define PS2_KEY_F1          0X61
#define PS2_KEY_F2          0X62
#define PS2_KEY_F3          0X63
#define PS2_KEY_F4          0X64
#define PS2_KEY_F5          0X65
#define PS2_KEY_F6          0X66
#define PS2_KEY_F7          0X67
#define PS2_KEY_F8          0X68
#define PS2_KEY_F9          0X69
#define PS2_KEY_F10         0X6A
#define PS2_KEY_F11         0X6B
#define PS2_KEY_F12         0X6C
#define PS2_KEY_F13         0X6D
#define PS2_KEY_F14         0X6E
#define PS2_KEY_F15         0X6F
#define PS2_KEY_F16         0X70
#define PS2_KEY_F17         0X71
#define PS2_KEY_F18         0X72
#define PS2_KEY_F19         0X73
#define PS2_KEY_F20         0X74
#define PS2_KEY_F21         0X75
#define PS2_KEY_F22         0X76
#define PS2_KEY_F23         0X77
#define PS2_KEY_F24         0X78
#define PS2_KEY_NEXT_TR     0X79
#define PS2_KEY_PREV_TR     0X7A
#define PS2_KEY_STOP        0X7B
#define PS2_KEY_PLAY        0X7C
#define PS2_KEY_MUTE        0X7D
#define PS2_KEY_VOL_UP      0X7E
#define PS2_KEY_VOL_DN      0X7F
#define PS2_KEY_MEDIA       0X80
#define PS2_KEY_EMAIL       0X81
#define PS2_KEY_CALC        0X82
#define PS2_KEY_COMPUTER    0X83
#define PS2_KEY_WEB_SEARCH  0X84
#define PS2_KEY_WEB_HOME    0X85
#define PS2_KEY_WEB_BACK    0X86
#define PS2_KEY_WEB_FORWARD 0X87
#define PS2_KEY_WEB_STOP    0X88
#define PS2_KEY_WEB_REFRESH 0X89
#define PS2_KEY_WEB_FAVOR   0X8A
#define PS2_KEY_EUROPE2     0X8B
#define PS2_KEY_POWER       0X8C
#define PS2_KEY_SLEEP       0X8D
#define PS2_KEY_WAKE        0X90
#define PS2_KEY_INTL1       0X91
#define PS2_KEY_INTL2       0X92
#define PS2_KEY_INTL3       0X93
#define PS2_KEY_INTL4       0X94
#define PS2_KEY_INTL5       0X95
#define PS2_KEY_LANG1       0X96
#define PS2_KEY_LANG2       0X97
#define PS2_KEY_LANG3       0X98
#define PS2_KEY_LANG4       0X99
#define PS2_KEY_LANG5       0xA0


/* Ignore code for key code translation */
#define PS2_KEY_IGNORE  0xBB

//  buffer sizes keyboard RX and TX, then key reading buffer
// Minimum size 8 can be larger
#define _RX_BUFFER_SIZE  8
// Minimum size 6 can be larger
#define _TX_BUFFER_SIZE  6
// Output Buffer of unsigned int values. Minimum size 4 can be larger
#define _KEY_BUFF_SIZE   4

/* private defines for library files not global */
/* _ps2mode status flags */
#define _PS2_BUSY        0x80
#define _TX_MODE         0x40
#define _BREAK_KEY       0x20
#define _WAIT_RESPONSE   0x10
#define _E0_MODE         0x08
#define _E1_MODE         0x04
#define _LAST_VALID      0x02

/* _tx_ready flags */
#define _HANDSHAKE       0x80
#define _COMMAND         0x01

/* Key Repeat defines */
#define _NO_BREAKS       0x08
#define _NO_REPEATS      0x80

/* PS2_keystatus byte masks (from 16 bit int masks) */
#define _BREAK    ( PS2_BREAK >> 8 )
#define _SHIFT    ( PS2_SHIFT >> 8 )
#define _CTRL     ( PS2_CTRL >> 8 )
#define _CAPS     ( PS2_CAPS >> 8 )
#define _ALT      ( PS2_ALT >> 8 )
#define _ALT_GR   ( PS2_ALT_GR >> 8 )
#define _GUI      ( PS2_GUI >> 8 )
#define _FUNCTION ( PS2_FUNCTION >> 8 )

/* General defines of comms codes */
/* Command or response */
#define PS2_KC_RESEND   0xFE
#define PS2_KC_ACK      0xFA
#define PS2_KC_ECHO     0xEE
/* Responses */
#define PS2_KC_BAT      0xAA
// Actually buffer overrun
#define PS2_KC_OVERRUN  0xFF
// Below is general error code
#define PS2_KC_ERROR    0xFC
#define PS2_KC_KEYBREAK 0xF0
#define PS2_KC_EXTEND1  0xE1
#define PS2_KC_EXTEND   0xE0
/* Commands */
#define PS2_KC_RESET    0xFF
#define PS2_KC_DEFAULTS 0xF6
#define PS2_KC_DISABLE  0xF5
#define PS2_KC_ENABLE   0xF4
#define PS2_KC_RATE     0xF3
#define PS2_KC_READID   0xF2
#define PS2_KC_SCANCODE 0xF0
#define PS2_KC_LOCK     0xED

/* Single Byte Key Codes */
#define PS2_KC_NUM      0x77
#define PS2_KC_SCROLL   0x7E
#define PS2_KC_CAPS     0x58
#define PS2_KC_L_SHIFT  0x12
#define PS2_KC_R_SHIFT  0x59
/* This is Left CTRL and ALT but Right version is in E0 with same code */
#define PS2_KC_CTRL     0X14
#define PS2_KC_ALT      0x11
/* Generated by some keyboards by ALT and PRTSCR */
#define PS2_KC_SYSRQ    0x84
#define PS2_KC_ESC      0x76
#define PS2_KC_BS       0x66
#define PS2_KC_TAB      0x0D
#define PS2_KC_ENTER    0x5A
#define PS2_KC_SPACE    0x29
#define PS2_KC_KP0      0x70
#define PS2_KC_KP1      0x69
#define PS2_KC_KP2      0x72
#define PS2_KC_KP3      0x7A
#define PS2_KC_KP4      0x6B
#define PS2_KC_KP5      0x73
#define PS2_KC_KP6      0x74
#define PS2_KC_KP7      0x6C
#define PS2_KC_KP8      0x75
#define PS2_KC_KP9      0x7D
#define PS2_KC_KP_DOT   0x71
#define PS2_KC_KP_PLUS  0x79
#define PS2_KC_KP_MINUS 0x7B
#define PS2_KC_KP_TIMES 0x7C
/* Some keyboards have an '=' on right keypad */
#define PS2_KC_KP_EQUAL 0x0F
#define PS2_KC_0        0X45
#define PS2_KC_1        0X16
#define PS2_KC_2        0X1E
#define PS2_KC_3        0X26
#define PS2_KC_4        0X25
#define PS2_KC_5        0X2E
#define PS2_KC_6        0X36
#define PS2_KC_7        0X3D
#define PS2_KC_8        0X3E
#define PS2_KC_9        0X46
#define PS2_KC_APOS     0X52
#define PS2_KC_COMMA    0X41
#define PS2_KC_MINUS    0X4E
#define PS2_KC_DOT      0X49
#define PS2_KC_DIV      0X4A
/* Single quote or back apostrophe */
#define PS2_KC_SINGLE   0X0E
#define PS2_KC_A        0X1C
#define PS2_KC_B        0X32
#define PS2_KC_C        0X21
#define PS2_KC_D        0X23
#define PS2_KC_E        0X24
#define PS2_KC_F        0X2B
#define PS2_KC_G        0X34
#define PS2_KC_H        0X33
#define PS2_KC_I        0X43
#define PS2_KC_J        0X3B
#define PS2_KC_K        0X42
#define PS2_KC_L        0X4B
#define PS2_KC_M        0X3A
#define PS2_KC_N        0X31
#define PS2_KC_O        0X44
#define PS2_KC_P        0X4D
#define PS2_KC_Q        0X15
#define PS2_KC_R        0X2D
#define PS2_KC_S        0X1B
#define PS2_KC_T        0X2C
#define PS2_KC_U        0X3C
#define PS2_KC_V        0X2A
#define PS2_KC_W        0X1D
#define PS2_KC_X        0X22
#define PS2_KC_Y        0X35
#define PS2_KC_Z        0X1A
#define PS2_KC_SEMI     0X4C
#define PS2_KC_BACK     0X5D
// Extra key left of Z on 102 keyboards
#define PS2_KC_EUROPE2  0x61
#define PS2_KC_OPEN_SQ  0X54
#define PS2_KC_CLOSE_SQ 0X5B
#define PS2_KC_EQUAL    0X55
#define PS2_KC_F1       0X05
#define PS2_KC_F2       0X06
#define PS2_KC_F3       0X04
#define PS2_KC_F4       0X0C
#define PS2_KC_F5       0X03
#define PS2_KC_F6       0X0B
#define PS2_KC_F7       0X83
#define PS2_KC_F8       0X0A
#define PS2_KC_F9       0X01
#define PS2_KC_F10      0X09
#define PS2_KC_F11      0X78
#define PS2_KC_F12      0X07
#define PS2_KC_F13      0X08
#define PS2_KC_F14      0X10
#define PS2_KC_F15      0X18
#define PS2_KC_F16      0X20
#define PS2_KC_F17      0X28
#define PS2_KC_F18      0X30
#define PS2_KC_F19      0X38
#define PS2_KC_F20      0X40
#define PS2_KC_F21      0X48
#define PS2_KC_F22      0X50
#define PS2_KC_F23      0X57
#define PS2_KC_F24      0X5F
#define PS2_KC_KP_COMMA 0X6D
#define PS2_KC_INTL1    0X51
#define PS2_KC_INTL2    0X13
#define PS2_KC_INTL3    0X6A
#define PS2_KC_INTL4    0X64
#define PS2_KC_INTL5    0X67
#define PS2_KC_LANG1    0XF2
#define PS2_KC_LANG2    0XF1
#define PS2_KC_LANG3    0X63
#define PS2_KC_LANG4    0X62
#define PS2_KC_LANG5    0X5F

/* Extended key codes E0 table for two byte codes */
/* PS2_CTRL and PS2_ALT Need using in any table for the right keys */
/* first is special case for PRTSCR not always used so ignored by decoding */
#define PS2_KC_IGNORE   0x12
#define PS2_KC_PRTSCR   0x7C
/* Sometimes called windows key */
#define PS2_KC_L_GUI    0x1F
#define PS2_KC_R_GUI    0x27
#define PS2_KC_MENU     0x2F
/* Break is CTRL + PAUSE generated inside keyboard */
#define PS2_KC_BREAK    0x7E
#define PS2_KC_HOME     0x6C
#define PS2_KC_END      0x69
#define PS2_KC_PGUP     0x7D
#define PS2_KC_PGDN     0x7A
#define PS2_KC_L_ARROW  0x6B
#define PS2_KC_R_ARROW  0x74
#define PS2_KC_UP_ARROW 0x75
#define PS2_KC_DN_ARROW 0x72
#define PS2_KC_INSERT   0x70
#define PS2_KC_DELETE   0x71
#define PS2_KC_KP_ENTER 0x5A
#define PS2_KC_KP_DIV   0x4A
#define PS2_KC_NEXT_TR  0X4D
#define PS2_KC_PREV_TR  0X15
#define PS2_KC_STOP     0X38
#define PS2_KC_PLAY     0X34
#define PS2_KC_MUTE     0X23
#define PS2_KC_VOL_UP   0X32
#define PS2_KC_VOL_DN   0X21
#define PS2_KC_MEDIA    0X50
#define PS2_KC_EMAIL    0X48
#define PS2_KC_CALC     0X2B
#define PS2_KC_COMPUTER 0X40
#define PS2_KC_WEB_SEARCH  0X10
#define PS2_KC_WEB_HOME    0X3A
#define PS2_KC_WEB_BACK    0X38
#define PS2_KC_WEB_FORWARD 0X30
#define PS2_KC_WEB_STOP    0X28
#define PS2_KC_WEB_REFRESH 0X20
#define PS2_KC_WEB_FAVOR   0X18
#define PS2_KC_POWER    0X37
#define PS2_KC_SLEEP    0X3F
#define PS2_KC_WAKE     0X5E


#define PS2_TAB				9
#define PS2_ENTER			13
#define PS2_LINEFEED			10
#define PS2_BACKSPACE			127
#define PS2_ESC				27
#define PS2_INSERT			0
#define PS2_DELETE			127
#define PS2_HOME			0
#define PS2_END				0
#define PS2_PAGEUP			25
#define PS2_PAGEDOWN			26
#define PS2_UPARROW			11
#define PS2_LEFTARROW			8
#define PS2_DOWNARROW			12
#define PS2_RIGHTARROW			21
#define PS2_F1				0
#define PS2_F2				0
#define PS2_F3				0
#define PS2_F4				0
#define PS2_F5				0
#define PS2_F6				0
#define PS2_F7				0
#define PS2_F8				0
#define PS2_F9				0
#define PS2_F10				0
#define PS2_F11				0
#define PS2_F12				0
#define PS2_SCROLL			0


/* Table contents are pairs of numbers
    first code from keyboard
    second is either PS2_KEY_IGNOPRE code or key code to return

   Single byte Key table
    In codes can only be 1 - 0x9F, plus 0xF2 and 0xF1
    Out Codes in range 1 to 0x9F
*/
#if defined(ARDUINO_ARCH_AVR)
const uint8_t PROGMEM single_key[][ 2 ] = {
#elif defined(ARDUINO_ARCH_SAM)
const uint8_t single_key[][ 2 ] = {
#endif
                { PS2_KC_NUM, PS2_KEY_NUM },
                { PS2_KC_SCROLL, PS2_KEY_SCROLL },
                { PS2_KC_CAPS, PS2_KEY_CAPS },
                { PS2_KC_L_SHIFT, PS2_KEY_L_SHIFT },
                { PS2_KC_R_SHIFT, PS2_KEY_R_SHIFT },
                { PS2_KC_CTRL, PS2_KEY_L_CTRL },
                { PS2_KC_ALT, PS2_KEY_L_ALT },
                { PS2_KC_SYSRQ, PS2_KEY_SYSRQ },
                { PS2_KC_ESC, PS2_KEY_ESC },
                { PS2_KC_BS, PS2_KEY_BS },
                { PS2_KC_TAB, PS2_KEY_TAB },
                { PS2_KC_ENTER, PS2_KEY_ENTER },
                { PS2_KC_SPACE, PS2_KEY_SPACE },
                { PS2_KC_KP0, PS2_KEY_KP0 },
                { PS2_KC_KP1, PS2_KEY_KP1 },
                { PS2_KC_KP2, PS2_KEY_KP2 },
                { PS2_KC_KP3, PS2_KEY_KP3 },
                { PS2_KC_KP4, PS2_KEY_KP4 },
                { PS2_KC_KP5, PS2_KEY_KP5 },
                { PS2_KC_KP6, PS2_KEY_KP6 },
                { PS2_KC_KP7, PS2_KEY_KP7 },
                { PS2_KC_KP8, PS2_KEY_KP8 },
                { PS2_KC_KP9, PS2_KEY_KP9 },
                { PS2_KC_KP_DOT, PS2_KEY_KP_DOT },
                { PS2_KC_KP_PLUS, PS2_KEY_KP_PLUS },
                { PS2_KC_KP_MINUS, PS2_KEY_KP_MINUS },
                { PS2_KC_KP_TIMES, PS2_KEY_KP_TIMES },
                { PS2_KC_KP_EQUAL, PS2_KEY_KP_EQUAL },
                { PS2_KC_0, PS2_KEY_0 },
                { PS2_KC_1, PS2_KEY_1 },
                { PS2_KC_2, PS2_KEY_2 },
                { PS2_KC_3, PS2_KEY_3 },
                { PS2_KC_4, PS2_KEY_4 },
                { PS2_KC_5, PS2_KEY_5 },
                { PS2_KC_6, PS2_KEY_6 },
                { PS2_KC_7, PS2_KEY_7 },
                { PS2_KC_8, PS2_KEY_8 },
                { PS2_KC_9, PS2_KEY_9 },
                { PS2_KC_APOS, PS2_KEY_APOS },
                { PS2_KC_COMMA, PS2_KEY_COMMA },
                { PS2_KC_MINUS, PS2_KEY_MINUS },
                { PS2_KC_DOT, PS2_KEY_DOT },
                { PS2_KC_DIV, PS2_KEY_DIV },
                { PS2_KC_SINGLE, PS2_KEY_SINGLE },
                { PS2_KC_A, PS2_KEY_A },
                { PS2_KC_B, PS2_KEY_B },
                { PS2_KC_C, PS2_KEY_C },
                { PS2_KC_D, PS2_KEY_D },
                { PS2_KC_E, PS2_KEY_E },
                { PS2_KC_F, PS2_KEY_F },
                { PS2_KC_G, PS2_KEY_G },
                { PS2_KC_H, PS2_KEY_H },
                { PS2_KC_I, PS2_KEY_I },
                { PS2_KC_J, PS2_KEY_J },
                { PS2_KC_K, PS2_KEY_K },
                { PS2_KC_L, PS2_KEY_L },
                { PS2_KC_M, PS2_KEY_M },
                { PS2_KC_N, PS2_KEY_N },
                { PS2_KC_O, PS2_KEY_O },
                { PS2_KC_P, PS2_KEY_P },
                { PS2_KC_Q, PS2_KEY_Q },
                { PS2_KC_R, PS2_KEY_R },
                { PS2_KC_S, PS2_KEY_S },
                { PS2_KC_T, PS2_KEY_T },
                { PS2_KC_U, PS2_KEY_U },
                { PS2_KC_V, PS2_KEY_V },
                { PS2_KC_W, PS2_KEY_W },
                { PS2_KC_X, PS2_KEY_X },
                { PS2_KC_Y, PS2_KEY_Y },
                { PS2_KC_Z, PS2_KEY_Z },
                { PS2_KC_SEMI, PS2_KEY_SEMI },
                { PS2_KC_BACK, PS2_KEY_BACK },
                { PS2_KC_OPEN_SQ, PS2_KEY_OPEN_SQ },
                { PS2_KC_CLOSE_SQ, PS2_KEY_CLOSE_SQ },
                { PS2_KC_EQUAL, PS2_KEY_EQUAL },
                { PS2_KC_EUROPE2, PS2_KEY_EUROPE2 },
                { PS2_KC_F1, PS2_KEY_F1 },
                { PS2_KC_F2, PS2_KEY_F2 },
                { PS2_KC_F3, PS2_KEY_F3 },
                { PS2_KC_F4, PS2_KEY_F4 },
                { PS2_KC_F5, PS2_KEY_F5 },
                { PS2_KC_F6, PS2_KEY_F6 },
                { PS2_KC_F7, PS2_KEY_F7 },
                { PS2_KC_F8, PS2_KEY_F8 },
                { PS2_KC_F9, PS2_KEY_F9 },
                { PS2_KC_F10, PS2_KEY_F10 },
                { PS2_KC_F11, PS2_KEY_F11 },
                { PS2_KC_F12, PS2_KEY_F12 },
                { PS2_KC_F13, PS2_KEY_F13 },
                { PS2_KC_F14, PS2_KEY_F14 },
                { PS2_KC_F15, PS2_KEY_F15 },
                { PS2_KC_F16, PS2_KEY_F16 },
                { PS2_KC_F17, PS2_KEY_F17 },
                { PS2_KC_F18, PS2_KEY_F18 },
                { PS2_KC_F19, PS2_KEY_F19 },
                { PS2_KC_F20, PS2_KEY_F20 },
                { PS2_KC_F21, PS2_KEY_F21 },
                { PS2_KC_F22, PS2_KEY_F22 },
                { PS2_KC_F23, PS2_KEY_F23 },
                { PS2_KC_F24, PS2_KEY_F24 },
                { PS2_KC_KP_COMMA, PS2_KEY_KP_COMMA },
                { PS2_KC_INTL1, PS2_KEY_INTL1 },
                { PS2_KC_INTL2, PS2_KEY_INTL2 },
                { PS2_KC_INTL3, PS2_KEY_INTL3 },
                { PS2_KC_INTL4, PS2_KEY_INTL4 },
                { PS2_KC_INTL5, PS2_KEY_INTL5 },
                { PS2_KC_LANG1, PS2_KEY_LANG1 },
                { PS2_KC_LANG2, PS2_KEY_LANG2 },
                { PS2_KC_LANG3, PS2_KEY_LANG3 },
                { PS2_KC_LANG4, PS2_KEY_LANG4 },
                { PS2_KC_LANG5, PS2_KEY_LANG5 }
                };

/* Two byte Key  table after an E0 byte received */
#if defined(ARDUINO_ARCH_AVR)
const uint8_t PROGMEM extended_key[][ 2 ] = {
#elif defined(ARDUINO_ARCH_SAM)
const uint8_t extended_key[][ 2 ] = {
#endif
                { PS2_KC_IGNORE, PS2_KEY_IGNORE },
                { PS2_KC_PRTSCR, PS2_KEY_PRTSCR },
                { PS2_KC_CTRL, PS2_KEY_R_CTRL },
                { PS2_KC_ALT, PS2_KEY_R_ALT },
                { PS2_KC_L_GUI, PS2_KEY_L_GUI },
                { PS2_KC_R_GUI, PS2_KEY_R_GUI },
                { PS2_KC_MENU, PS2_KEY_MENU },
                { PS2_KC_BREAK, PS2_KEY_BREAK },
                { PS2_KC_HOME, PS2_KEY_HOME },
                { PS2_KC_END, PS2_KEY_END },
                { PS2_KC_PGUP, PS2_KEY_PGUP },
                { PS2_KC_PGDN, PS2_KEY_PGDN },
                { PS2_KC_L_ARROW, PS2_KEY_L_ARROW },
                { PS2_KC_R_ARROW, PS2_KEY_R_ARROW },
                { PS2_KC_UP_ARROW, PS2_KEY_UP_ARROW },
                { PS2_KC_DN_ARROW, PS2_KEY_DN_ARROW },
                { PS2_KC_INSERT, PS2_KEY_INSERT },
                { PS2_KC_DELETE, PS2_KEY_DELETE },
                { PS2_KC_KP_ENTER, PS2_KEY_KP_ENTER },
                { PS2_KC_KP_DIV, PS2_KEY_KP_DIV },
                { PS2_KC_NEXT_TR, PS2_KEY_NEXT_TR },
                { PS2_KC_PREV_TR, PS2_KEY_PREV_TR },
                { PS2_KC_STOP, PS2_KEY_STOP },
                { PS2_KC_PLAY, PS2_KEY_PLAY },
                { PS2_KC_MUTE, PS2_KEY_MUTE },
                { PS2_KC_VOL_UP, PS2_KEY_VOL_UP },
                { PS2_KC_VOL_DN, PS2_KEY_VOL_DN },
                { PS2_KC_MEDIA, PS2_KEY_MEDIA },
                { PS2_KC_EMAIL, PS2_KEY_EMAIL },
                { PS2_KC_CALC, PS2_KEY_CALC },
                { PS2_KC_COMPUTER, PS2_KEY_COMPUTER },
                { PS2_KC_WEB_SEARCH, PS2_KEY_WEB_SEARCH },
                { PS2_KC_WEB_HOME, PS2_KEY_WEB_HOME },
                { PS2_KC_WEB_BACK, PS2_KEY_WEB_BACK },
                { PS2_KC_WEB_FORWARD, PS2_KEY_WEB_FORWARD },
                { PS2_KC_WEB_STOP, PS2_KEY_WEB_STOP },
                { PS2_KC_WEB_REFRESH, PS2_KEY_WEB_REFRESH },
                { PS2_KC_WEB_FAVOR, PS2_KEY_WEB_FAVOR },
                { PS2_KC_POWER, PS2_KEY_POWER },
                { PS2_KC_SLEEP, PS2_KEY_SLEEP },
                { PS2_KC_WAKE, PS2_KEY_WAKE }
                };

/* Scroll lock numeric keypad re-mappings for NOT NUMLOCK */
/* in translated code order order is important */
#if defined(ARDUINO_ARCH_AVR)
const uint8_t PROGMEM scroll_remap[] = {
#elif defined(ARDUINO_ARCH_SAM)
const uint8_t scroll_remap[] = {
#endif
                PS2_KEY_INSERT,     // PS2_KEY_KP0
                PS2_KEY_END,        // PS2_KEY_KP1
                PS2_KEY_DN_ARROW,   // PS2_KEY_KP2
                PS2_KEY_PGDN,       // PS2_KEY_KP3
                PS2_KEY_L_ARROW,    // PS2_KEY_KP4
                PS2_KEY_IGNORE,     // PS2_KEY_KP5
                PS2_KEY_R_ARROW,    // PS2_KEY_KP6
                PS2_KEY_HOME,       // PS2_KEY_KP7
                PS2_KEY_UP_ARROW,   // PS2_KEY_KP8
                PS2_KEY_PGUP,       // PS2_KEY_KP9
                PS2_KEY_DELETE      // PS2_KEY_KP_DOT
                };
								
#if defined(ARDUINO_ARCH_AVR)
const char PROGMEM PS2_ASCII[] = {
#elif defined(ARDUINO_ARCH_SAM)
const char PS2_ASCII[] = {
#endif
	' ','0','1','2','3','4','5','6','7','8','9','.','\r','+','-','*','/','0','1','2','3','4','5','6','7','8','9','\'',',','-','.','/','=','`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',';','\\','[',']','=',',',
	' ','0','1','2','3','4','5','6','7','8','9','.','\r','+','-','*','/',')','!','@','#','$','%','^','&','*','(','"','<','_','>','?','=','~','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',':','|','{','}','+',',',
};
#endif
