/*
 * GSM.h
 * A library for SeeedStudio seeeduino GPRS shield 
 *
 * Copyright (c) 2013 seeed technology inc.
 * Author        :   lawliet zou
 * Create Time   :   Dec 2013
 * Change Log    :
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/*
 * improved by semesin (http://www.semesin.com/project/)
 */

#ifndef __GSM_H__
#define __GSM_H__

#include "Arduino.h"
#include <SoftwareSerial.h>

#define UART_DEBUG

#ifdef UART_DEBUG
#define ERROR(x)            Serial.print("\r\nError:");Serial.println(x)
#define DEBUG(x)            Serial.write(x)
#define COMMAND(x)          Serial.print("\r\nCommand:");Serial.write(x)

#else
#define ERROR(x)
#define DEBUG(x)
#define COMMAND(x)
#endif

#define errorOK 0
#define errorOtherOK -1
#define errorTimeout -2
#define errorResponse -3
#define errorNoSpace -4

#define newEventSMS 0s
#define newEventCall 0xCA

#define DEFAULT_TIMEOUT     5000

/** GSM class.
 *  Used for GSM communication. attention that GSM module communicate with MCU in serial protocol
 */
class GSM
{

	public:
		char _resetPin;
		Stream *serialGSM;
		bool HardwareSerialMode;
		HardwareSerial *hwSerial;
		SoftwareSerial *swSerial;
    uint32_t _ip;
    char ip_string[20];
		String incomingBuffer;

		GSM(HardwareSerial *serial, char resetPin, uint32_t baudRate);
		GSM(SoftwareSerial *serial, char resetPin, uint32_t baudRate);

		void reset(void);
    int init(uint32_t baudRate = 9600);
		bool waitGSMReady();
		
		int readBuffer(char* buffer,int *length, unsigned int timeOut = DEFAULT_TIMEOUT);
		void sendCmd(const char* cmd);
		int sendATTest(void);
		int waitForResp(const char* resp, unsigned timeout);
		int sendCmdAndWaitForResp(const char* cmd, const char *resp, unsigned timeout);
		int sendCmdAndWaitForParam(const char* cmd, const char *resp, unsigned timeout);
		int sendCmdAndWaitForStatus(const char* cmd, unsigned timeout);
		void serialDebug(void);
		void writeDebug(void);
		void SMSListDebug(void);

		byte checkEvent();

    int checkGSMStatus(void);
    int sendSMS(char* number, char* data);
    int readSMS(int Index, String *messageBuffer, String *numberBuffer);
    int deleteSMS(int index);

    int callUp(char* number);
    int answer(void);
    int join(const char  *apn = 0, const char *userName = 0, const char *passWord = 0);
    uint32_t str_to_ip(const char* str);
    char* getIPAddress();
    int networkCheck(void);
    int connectTCP(const char* ip, int port);
    int sendTCPData(char* data);
    int closeTCP(void);
    int shutTCP(void);

		private:
    
};

#endif