/*
 * improved by semesin (http://www.semesin.com/project/)
 */
#include "GSM.h"

void GSM::reset(void)
{
	digitalWrite(_resetPin,LOW);
	if(_resetPin >= 0)
	{
		pinMode(_resetPin,OUTPUT);
		delay(500);
		pinMode(_resetPin,INPUT);
	}
	while(sendATTest() != 0);                
}

GSM::GSM(HardwareSerial *serial, char resetPin, uint32_t baudRate)
{
	_resetPin = resetPin;
	serialGSM = serial;
	hwSerial = serial;
	serial->begin(baudRate);
	HardwareSerialMode = true;
};
GSM::GSM(SoftwareSerial *serial, char resetPin, uint32_t baudRate)
{
	_resetPin = resetPin;
	serialGSM = serial;
	swSerial = serial;
	serial->begin(baudRate);
	HardwareSerialMode = false;
};


int GSM::init(uint32_t baudRate)
{
	char cmd[18];
	char resp[24];
	snprintf(cmd, sizeof(cmd), "AT+IPR=%lu", baudRate);
	snprintf(resp, sizeof(resp), "AT+IPR=%lu\r\r\nOK", baudRate);
	int respond;
	
	//AT+CNMI=2,1,0,0,0
	
	// sendCmdAndWaitForResp("ATE1", "OK", DEFAULT_TIMEOUT);
	
	if((respond = sendCmdAndWaitForStatus("AT+CFUN=1", DEFAULT_TIMEOUT*3)) != errorOK)
	{
		return respond;
	}
	delay(2000);
	// if((respond = sendCmdAndWaitForResp("AT+CREG=1", "+CREG: 0", DEFAULT_TIMEOUT*3)) != errorOK)
	// {
		// return respond;
	// }
	// if((respond = sendCmdAndWaitForResp("AT+CPIN?", "AT+CPIN?\r\r\n+CPIN: READY\r\n\r\nOK", DEFAULT_TIMEOUT*3)) != errorOK)
	// {
		// return respond;
	// }
	// if((respond = sendCmdAndWaitForStatus("AT+CREG=1", DEFAULT_TIMEOUT*3)) != errorOK)
	// {
		// return respond;
	// }
	// if((respond = sendCmdAndWaitForResp("AT+CREG=1", "\r\n\r\n+CREG: 2", DEFAULT_TIMEOUT*3)) != errorOK)
	// {
		// return respond;
	// }
	// if((respond = sendCmdAndWaitForResp("AT+CREG=1", "\r\n\r\n+CREG: 1", DEFAULT_TIMEOUT*3)) != errorOK)
	// {
		// return respond;
	// }
	if((respond = sendCmdAndWaitForStatus("ATE1", DEFAULT_TIMEOUT*3)) != errorOK)
	{
		return respond;
	}
	if((respond = sendCmdAndWaitForStatus("AT+CMGF=1", DEFAULT_TIMEOUT*3)) != errorOK)
	{
		return respond;
	}
	
	if((respond = sendCmdAndWaitForResp(cmd, resp, DEFAULT_TIMEOUT*3)) != errorOK)
	{
		return respond;
	}
	if(HardwareSerialMode)
	{
		hwSerial->begin(baudRate);
	}
	else
	{
		swSerial->begin(baudRate);
	}

	incomingBuffer = "";
	return errorOK;
}

int GSM::checkGSMStatus(void)
{
	return sendCmdAndWaitForResp("AT+CPIN?","AT+CPIN?\r\r\n+CPIN: READY",DEFAULT_TIMEOUT*3);
}

int GSM::readBuffer(char *buffer, int *length, unsigned int timeOut)
{
	int i = 0;
	unsigned long timerStart;
	int sumError=0;
	char error[] = "ERROR";
	int sumOK=0;
	char ok[] = "\r\n\r\nOK";
	
	timerStart = millis();
	while(1) {
		while(serialGSM->available()) 
		{
			char c = serialGSM->read();
			DEBUG(c);
			buffer[i++] = c;

			sumError = (c==error[sumError]) ? sumError+1 : 0;
			sumOK = (c==ok[sumOK]) ? sumOK+1 : 0;
			
			if(sumError == sizeof(error)-1)
			{
				return errorResponse;
			}
			if(sumOK == sizeof(ok)-1)
			{
				*length = i;
				return errorOK;
			}
			if(i == *length)
			{
				*length = i;
				return errorNoSpace;
			}
		}
		if(millis() - timerStart > timeOut) 
		{
			*length = i;
			return errorTimeout;
		}
	}
}

void GSM::sendCmd(const char* cmd)
{
	serialGSM->write(cmd);
	serialGSM->write('\r');
}

int GSM::sendATTest(void)
{
	return sendCmdAndWaitForResp("AT","AT\r\r\nOK",DEFAULT_TIMEOUT);
}

int GSM::waitForResp(const char *resp, unsigned int timeout)
{
	int len = strlen(resp);
	int sum=0;
	int sumError=0;
	int sumOK=0;
	unsigned long timerStart = millis();
	char error[] = "ERROR";
	char ok[] = "OK";
	
	while(1) {
		while(serialGSM->available()) {
			char c = serialGSM->read();
			DEBUG(c);
			
			sum = (c==resp[sum]) ? sum+1 : 0;
			sumError = (c==error[sumError]) ? sumError+1 : 0;
			sumOK = (c==ok[sumOK]) ? sumOK+1 : 0;
			if(sum == len)
				return errorOK;
			if(sumOK == sizeof(ok)-1)
				return errorOtherOK;
			if(sumError == sizeof(error)-1)
				return errorResponse;
		}
		if(millis() - timerStart > timeout) {
				return errorTimeout;
		}
	}
	
}
bool GSM::waitGSMReady()
{ 
  bool SMSReady = false;
  bool CallReady = false;
	char SMSReadyText[] = "SMS Ready";
	char CallReadyText[] = "Call Ready";
	int sumSMSReady=0;
	int sumCallReady=0;
	unsigned long timerStart = millis();
	unsigned long timeout = 30000;

  
	while(1) {
		while(serialGSM->available()) {
			char c = serialGSM->read();
			DEBUG(c);
			
			sumSMSReady = (c==SMSReadyText[sumSMSReady]) ? sumSMSReady+1 : 0;
			sumCallReady = (c==CallReadyText[sumCallReady]) ? sumCallReady+1 : 0;

			if(sumSMSReady == sizeof(SMSReadyText)-1)
				SMSReady = true;
			if(sumCallReady == sizeof(CallReadyText)-1)
				CallReady = true;
			if(SMSReady && CallReady)
				return true;
		}
		if(millis() - timerStart > timeout) {
				break;
		}
		if(!((millis() - timerStart) % 2000L)) {
			sendCmd("AT\r");
			delay(500);
		}
	}
	return false;
}

int GSM::sendCmdAndWaitForResp(const char* cmd, const char *resp, unsigned timeout)
{
	COMMAND(cmd);
	sendCmd(cmd);
	return waitForResp(resp,timeout);
}

int GSM::sendCmdAndWaitForParam(const char* cmd, const char *param, unsigned timeout)
{
	DEBUG(cmd);
	sendCmd(cmd);
	int respond;
	if((respond = waitForResp("OK",timeout)) != errorOK)
	{
		return respond;
	}
	Serial.print("===========");
	Serial.println(param);
	return waitForResp(param,timeout);
}


int GSM::sendCmdAndWaitForStatus(const char* cmd, unsigned timeout)
{
	COMMAND(cmd);
	sendCmd(cmd);
	return waitForResp("OK",timeout);
}

int GSM::join(const char *apn, const char *userName, const char *passWord)
{
	int respond;
	char ipAddr[32];
	char cmd[100];
	char resp[100];
	
	if((respond = sendCmdAndWaitForResp("AT+CIPSHUT", "AT+CIPSHUT\r\r\nSHUT OK", DEFAULT_TIMEOUT*2)) != errorOK)
	{
		return respond;
	}
	if((respond = sendCmdAndWaitForResp("AT+CREG?", "AT+CREG?\r\r\n+CREG: 0,1\r\n\r\nOK", DEFAULT_TIMEOUT)) != errorOK)
	{
		return respond;
	}
	if((respond = sendCmdAndWaitForResp("AT+CIPMUX=0", "AT+CIPMUX=0\r\r\nOK", DEFAULT_TIMEOUT*2)) != errorOK)
	{
		return respond;
	}
	if((respond = sendCmdAndWaitForResp("AT+CIPSTATUS", "AT+CIPSTATUS\r\r\nOK\r\n\r\nSTATE: IP INITIAL", DEFAULT_TIMEOUT*2)) != errorOK)
	{
		return respond;
	}
	snprintf(cmd, sizeof(cmd), "AT+CSTT=\"%s\",\"%s\",\"%s\"", apn, userName, passWord);
	snprintf(resp, sizeof(resp), "AT+CSTT=\"%s\",\"%s\",\"%s\"\r\r\nOK", apn, userName, passWord);
	if((respond = sendCmdAndWaitForResp(cmd, resp, DEFAULT_TIMEOUT*2)) != errorOK)
	{
		return respond;
	}
	if((respond = sendCmdAndWaitForResp("AT+CIPSTATUS", "AT+CIPSTATUS\r\r\nOK\r\n\r\nSTATE: IP START", DEFAULT_TIMEOUT)) != errorOK)
	{
		return respond;
	}
	if((respond = sendCmdAndWaitForResp("AT+CIICR", "AT+CIICR\r\r\nOK", DEFAULT_TIMEOUT)) != errorOK)
	{
		return respond;
	}
	if((respond = sendCmdAndWaitForResp("AT+CIPSTATUS", "AT+CIPSTATUS\r\r\nOK\r\n\r\nSTATE: IP GPRSACT", DEFAULT_TIMEOUT)) != errorOK)
	{
		return respond;
	}
	
	int respondLength = 32;
	sendCmd("AT+CIFSR\r");
	respond = readBuffer(ipAddr,&respondLength, 1000);        
	_ip = str_to_ip(ipAddr+11);
	if(_ip == 0) {
		return respond;
	}
	
	for(byte i =0;i<3;i++)
	{
		if((respond = sendCmdAndWaitForResp("AT+CIPSTATUS", "AT+CIPSTATUS\r\r\nOK\r\n\r\nSTATE: IP STATUS", DEFAULT_TIMEOUT)) == errorOK)
		{
			return errorOK;
		}
	}
	return respond;
}

int GSM::connectTCP(const char *ip, int port)
{
	char cmd[50];
	char resp[50];
	int respond;

	sprintf(cmd, "AT+CIPSTART=\"TCP\",\"%s\",\"%d\"", ip, port);
	sprintf(resp, "AT+CIPSTART=\"TCP\",\"%s\",\"%d\"\r\r\nOK\r\n\r\nCONNECT OK", ip, port);
	return sendCmdAndWaitForResp(cmd, resp, DEFAULT_TIMEOUT*2);
}

int GSM::sendTCPData(char *data)
{
	char cmd[32];
	char resp[64];
	int len = strlen(data); 
	int respond;

	snprintf(cmd,sizeof(cmd), "AT+CIPSEND=%d",len);
	snprintf(resp,sizeof(resp), "AT+CIPSEND=%d\r\r\n>",len);
	if((respond = sendCmdAndWaitForResp(cmd, resp, DEFAULT_TIMEOUT*2)) != errorOK) {
		return respond;
	}
			
	sendCmd(data);
	serialGSM->write((char)26);
			
	return waitForResp("\r\nSEND OK", DEFAULT_TIMEOUT*3);
}

int GSM::closeTCP(void)
{
	sendCmd("AT+CIPCLOSE\r");
	return errorOK;
}

int GSM::shutTCP(void)
{
	sendCmd("AT+CIPSHUT\r");
	return errorOK;
}

uint32_t GSM::str_to_ip(const char* str)
{
	uint32_t ip = 0;
	char *p = (char*)str;
	
	for(int i = 0; i < 4; i++) {
		ip |= atoi(p);
		p = strchr(p, '.');
		if (p == NULL) {
			break;
		}
		if(i < 3) ip <<= 8;
		p++;
	}
	return ip;
}

//HACERR lo de la IP gasta muuuucho espacio (ver .h y todo esto)
char* GSM::getIPAddress()
{
	uint8_t a = (_ip>>24)&0xff;
	uint8_t b = (_ip>>16)&0xff;
	uint8_t c = (_ip>>8)&0xff;
	uint8_t d = _ip&0xff;

	snprintf(ip_string, sizeof(ip_string), "%d.%d.%d.%d", a,b,c,d);
	return ip_string;
}

int GSM::networkCheck(void)
{
	int respond;
	delay(1000);
	if((respond = sendCmdAndWaitForResp("AT+CGREG?","+CGREG: 0,1",DEFAULT_TIMEOUT*3)) != errorOK) {
		return respond;
	}
	delay(1000);
	if((respond = sendCmdAndWaitForResp("AT+CGATT?","+CGATT: 1",DEFAULT_TIMEOUT)) != errorOK) {
		return respond;
	}
	return errorOK;
}

int GSM::sendSMS(char *number, char *data)
{
	char cmd[32];
	char resp[32];
	int respond;
	
	if((respond = sendCmdAndWaitForResp("AT+CMGF=1", "AT+CMGF=1\r\r\nOK", DEFAULT_TIMEOUT)) != errorOK) {
		return respond;
	}
	delay(500);
	snprintf(cmd, sizeof(cmd), "AT+CMGS=\"%s\"", number);
	snprintf(resp, sizeof(resp), "AT+CMGS=\"%s\"\r\r\n> ", number);

	if((respond = sendCmdAndWaitForResp(cmd,resp,DEFAULT_TIMEOUT*10)) == errorOK) 
	{
		serialGSM->print(data);
		while(waitForResp(data, DEFAULT_TIMEOUT*5) != errorOK);
		serialGSM->write((char)26);
		if((respond = waitForResp("\r\n\r\nOK", DEFAULT_TIMEOUT*3)) == errorOK)
		{
			return errorOK;
		}
	}
	return respond;
}

int GSM::readSMS(int Index, String *messageBuffer, String *numberBuffer)
{
	char cmd[16];// = "AT+CMGL=\"ALL\"\r";
	char *p,*s;
	int respond;
	int respondLength = 300;
	char ResponText[300];
	
	*messageBuffer = "";
	*numberBuffer = "";
	

	if((respond = sendCmdAndWaitForResp("AT+CMGF=1","AT+CMGF=1\r\r\nOK",DEFAULT_TIMEOUT*3)) == errorOK)
	{
		sprintf(cmd,"AT+CMGR=%d\r",Index);
		serialGSM->write(cmd);
		respond = readBuffer(ResponText, &respondLength, DEFAULT_TIMEOUT*3);
		if(respond == errorOK)
		{
			int i;
			byte csvIndex = 0;
			byte lineIndex = 0;
			
			for(i=0;i<respondLength;i++)
			{
				char c = ResponText[i];
				if(csvIndex == 1)
				{
					if((c != '\"') && (c != ','))
					{
						*numberBuffer += c;
					}
				}
				if(lineIndex == 3)
				{
					if((c != '\"') && (c != '\r') && (c != '\n'))
					{
						*messageBuffer += c;
					}
				}
				if(c == ',')
				{
					csvIndex++;
				}
				else if(c == '\n')
				{
					lineIndex++;
				}
			}			
			return errorOK;
		}
	}
	return respond;
}
void GSM::SMSListDebug(void)
{
	sendCmd("AT+CMGL=\"ALL\"\r");
	delay(DEFAULT_TIMEOUT);
	while(serialGSM->available())
	{
		char c = serialGSM->read();
		DEBUG(c);
	}		
}
byte GSM::checkEvent()
{
	byte sum = 0;
	char CMTI[] = "+CMTI: \"SM\",";
	bool newIncomingSMS = false;
	String newIncomingSMSIndex = "";
	while(serialGSM->available())
	{
		char c = serialGSM->read();
		// DEBUG(c);
		// Serial.print(" ");
		Serial.print(c, HEX);
		if(c == '\n')
		{
			int pos = incomingBuffer.indexOf("+CMTI: \"SM\",");
			if(pos >= 0)
			{
				incomingBuffer = incomingBuffer.substring(pos);
				int index = incomingBuffer.substring(12, incomingBuffer.indexOf('\r')).toInt();
				incomingBuffer = "";
				return index;
			}
			else if(incomingBuffer.indexOf("RING") >= 0)
			{
				incomingBuffer = "";
				return newEventCall;
			}
		}
		else
		{
			incomingBuffer += c;
		}
	}
	return 0;
}

int GSM::deleteSMS(int index)
{
	char cmd[16];
	char resp[16];
	snprintf(cmd,sizeof(cmd), "AT+CMGD=%d",index);
	snprintf(resp,sizeof(resp), "AT+CMGD=%d\r\nOK",index);
	return sendCmdAndWaitForResp(cmd, resp, DEFAULT_TIMEOUT);
}

int GSM::callUp(char *number)
{
	char cmd[24];
	int respond;
	
	if((respond = sendCmdAndWaitForResp("AT+COLP=1","AT+COLP=1\r\r\nOK",DEFAULT_TIMEOUT)) != errorOK) {
		return respond;
	}
	delay(1000);
	sprintf(cmd,"\rATD%s;\r", number);
	serialGSM->write(cmd);
	return errorOK;
}

int GSM::answer(void)
{
	serialGSM->write("ATA\r");
	return errorOK;
}

void GSM::serialDebug(void)
{
	while(1) {
		if(serialGSM->available()){
			Serial.write(serialGSM->read());
		}
		if(Serial.available()){     
			serialGSM->write(Serial.read()); 
		}
	}
}
void GSM::writeDebug(void)
{
	if(Serial.available()){     
		serialGSM->write(Serial.read()); 
	}
}
