#include <sim800l.h>
#include <SoftwareSerial.h>

//Software serial
#define pinSIM800RX 2
#define pinSIM800TX 3
#define pinSIM800Reset 4
SoftwareSerial mySerial(pinSIM800RX, pinSIM800TX); // RX, TX jika menggunakan software serial
SIM800 sim(&mySerial, pinSIM800Reset, 9600);

//Hardware serial
//#define pinSIM800Serial Serial1
//#define pinSIM800Reset 17
//SIM800 sim(&pinSIM800Serial, pinSIM800Reset, 9600);//Menggunakan hardware serial

char APN[]      = "internet";
char Username[] = "";
char password[] = "";


char Servername[] = "telkomsel.com";
char http_cmd[] = "GET /telkomsel.com HTTP/1.0\r\n\r\n";
int port = 8000;

void setup() {
  Serial.begin(9600);
  Serial.println("SIM800L - Permintaan data dari internet");
  Serial.println("http://www.semesin.com/project/");

  Serial.println();
  Serial.println("Inisialisasi...");

  while(sim.init(9600) != 0) {
    Serial.println("Mengulangi inisialisasi");
  }  
  Serial.println("Menghubungkan ke jaringan selular");
  while(!sim.waitSIMReady());
  Serial.println("Pusat data telah aktif");

  Serial.println("Menghubungkan ke jaringan internet...");
  while(sim.join(APN, Username, password) != 0) 
  {
    Serial.println("Mengulang koneksi ke internet");
  }

  // successful DHCP
  Serial.print("IP Address : ");
  Serial.println(sim.getIPAddress());
  
  Serial.println("Mengkoneksikan ke server...");
  if(sim.connectTCP(Servername, port) == 0) {
    Serial.println("Berhasil terkoneksi ke server");
  }else{
    Serial.println("Gagal menghubingi server");
    while(1);
  }

  Serial.println("Mengambil data...");
  if(sim.sendTCPData(http_cmd) == 0)
  {      
    Serial.println("Berhasil mengirimkan permintaan data ke internet");
  }
  else
  {      
    Serial.println("Gagal mengirimkan permintaan data ke internet");
    sim.closeTCP();
  }
}

void loop() {
  sim.serialDebug();
}