

/*
 *
 * TimesNewRoman12
 *
 * created with FontCreator
 * written by F. Maximilian Thiele
 *
 * http://www.apetech.de/fontCreator
 * me@apetech.de
 *
 * File Name           : TimesNewRoman12.h
 * Date                : 11.03.2018
 * Font size in bytes  : 13328
 * Font width          : 10
 * Font height         : 17
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef TIMESNEWROMAN12_H
#define TIMESNEWROMAN12_H

#define TIMESNEWROMAN12_WIDTH 10
#define TIMESNEWROMAN12_HEIGHT 17

const static uint8_t TimesNewRoman12[] PROGMEM = {
    0x34, 0x10, // size
    0x0A, // width
    0x11, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x02, 0x05, 0x09, 0x07, 0x0F, 0x0D, 0x02, 0x05, 0x05, 
    0x07, 0x09, 0x03, 0x04, 0x02, 0x05, 0x07, 0x06, 0x08, 0x07, 
    0x08, 0x06, 0x08, 0x08, 0x08, 0x08, 0x02, 0x03, 0x09, 0x0A, 
    0x09, 0x06, 0x0F, 0x0C, 0x0B, 0x0A, 0x0C, 0x0B, 0x0A, 0x0C, 
    0x0D, 0x06, 0x07, 0x0D, 0x0B, 0x10, 0x0D, 0x0B, 0x0A, 0x0B, 
    0x0C, 0x08, 0x0A, 0x0D, 0x0C, 0x11, 0x0D, 0x0D, 0x0B, 0x04, 
    0x05, 0x04, 0x08, 0x09, 0x03, 0x07, 0x08, 0x06, 0x08, 0x06, 
    0x05, 0x07, 0x09, 0x04, 0x04, 0x09, 0x04, 0x0E, 0x09, 0x07, 
    0x08, 0x08, 0x06, 0x05, 0x05, 0x09, 0x09, 0x0D, 0x08, 0x09, 
    0x08, 0x06, 0x01, 0x06, 0x09, 0x09, 
    
    // font data
    0xFE, 0x3E, 0x1B, 0x18, 0x00, 0x00, // 33
    0x3E, 0x0E, 0x00, 0x3E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x20, 0x20, 0xF8, 0x27, 0x20, 0x20, 0xF8, 0x27, 0x20, 0x02, 0x1E, 0x03, 0x02, 0x02, 0x1E, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 35
    0x1C, 0x3E, 0x62, 0xFF, 0xC2, 0x86, 0x0C, 0x0C, 0x18, 0x10, 0x3F, 0x10, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 36
    0x3C, 0x7E, 0x42, 0x42, 0x7E, 0x3C, 0x80, 0x40, 0x20, 0x18, 0x84, 0x82, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x02, 0x01, 0x00, 0x00, 0x0F, 0x1F, 0x10, 0x10, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 37
    0x00, 0x00, 0x80, 0x5C, 0x7E, 0xE2, 0xB2, 0x1C, 0x20, 0xE0, 0x60, 0x20, 0x00, 0x0E, 0x1F, 0x18, 0x10, 0x10, 0x0B, 0x0F, 0x0E, 0x19, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 38
    0x3E, 0x0E, 0x00, 0x00, 0x00, 0x00, // 39
    0xE0, 0xF8, 0x0C, 0x02, 0x01, 0x0F, 0x3F, 0x60, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, // 40
    0x01, 0x02, 0x0C, 0xF8, 0xE0, 0x00, 0x80, 0x60, 0x3F, 0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, // 41
    0x24, 0x24, 0x18, 0xFF, 0x18, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x40, 0x40, 0x40, 0x40, 0xFC, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x98, 0x58, 0x30, 0x00, 0x00, 0x00, // 44
    0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, // 45
    0x00, 0x00, 0x18, 0x18, 0x00, 0x00, // 46
    0x00, 0x00, 0xE0, 0x1C, 0x03, 0x18, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 47
    0xF0, 0xFC, 0x06, 0x02, 0x06, 0xFC, 0xF0, 0x03, 0x0F, 0x18, 0x10, 0x18, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 48
    0x04, 0x04, 0xFE, 0xFE, 0x00, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 49
    0x08, 0x04, 0x02, 0x02, 0x86, 0xFE, 0x3C, 0x00, 0x10, 0x18, 0x1C, 0x1A, 0x19, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 50
    0x0C, 0x04, 0x02, 0x42, 0xE6, 0xFE, 0x9C, 0x18, 0x18, 0x10, 0x10, 0x18, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 51
    0x00, 0x80, 0x60, 0x10, 0x08, 0xFE, 0xFE, 0x00, 0x03, 0x02, 0x02, 0x02, 0x02, 0x1F, 0x1F, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 52
    0x20, 0x38, 0x36, 0x76, 0xE6, 0xC6, 0x18, 0x10, 0x10, 0x10, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 53
    0xC0, 0xF0, 0x58, 0x2C, 0x24, 0x66, 0xC2, 0x82, 0x07, 0x0F, 0x18, 0x10, 0x10, 0x18, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 54
    0x08, 0x06, 0x06, 0x06, 0x86, 0x76, 0x0E, 0x02, 0x00, 0x00, 0x10, 0x0E, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 55
    0x18, 0x3C, 0xE6, 0xC2, 0xC2, 0xA2, 0x3C, 0x18, 0x06, 0x0F, 0x18, 0x10, 0x10, 0x11, 0x0F, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 56
    0x78, 0xFC, 0x86, 0x02, 0x02, 0x06, 0xFC, 0xF8, 0x10, 0x10, 0x11, 0x09, 0x0D, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 57
    0x60, 0x60, 0x18, 0x18, 0x00, 0x00, // 58
    0x60, 0x60, 0x00, 0x98, 0x58, 0x30, 0x00, 0x00, 0x00, // 59
    0x40, 0xA0, 0xA0, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 60
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 61
    0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0xA0, 0xA0, 0x40, 0x04, 0x02, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 62
    0x1C, 0x1E, 0x02, 0xC2, 0x7E, 0x3C, 0x00, 0x00, 0x1B, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 63
    0xC0, 0x30, 0x0C, 0x04, 0x82, 0xE1, 0x61, 0x31, 0x11, 0x21, 0xE3, 0x32, 0x0C, 0xF0, 0x00, 0x0F, 0x30, 0x40, 0x8F, 0x9F, 0x11, 0x08, 0x08, 0x1C, 0x1F, 0x91, 0x88, 0x46, 0x21, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, // 64
    0x00, 0x00, 0x00, 0x80, 0x70, 0x0C, 0x1E, 0xFC, 0xE0, 0x00, 0x00, 0x00, 0x10, 0x18, 0x1E, 0x11, 0x01, 0x01, 0x01, 0x11, 0x1F, 0x1F, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 65
    0x02, 0x02, 0xFE, 0xFE, 0x42, 0x42, 0x42, 0x42, 0xFE, 0xBC, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x18, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 66
    0xF0, 0xF8, 0x0C, 0x06, 0x02, 0x02, 0x02, 0x02, 0x04, 0x1E, 0x03, 0x07, 0x0C, 0x18, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 67
    0x02, 0x02, 0xFE, 0xFE, 0x02, 0x02, 0x02, 0x02, 0x06, 0x0C, 0xF8, 0xF0, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x18, 0x0C, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 68
    0x02, 0x02, 0xFE, 0xFE, 0x42, 0x42, 0x42, 0xF2, 0x02, 0x0E, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x10, 0x11, 0x10, 0x18, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 69
    0x02, 0x02, 0xFE, 0xFE, 0x42, 0x42, 0x42, 0xF2, 0x02, 0x0E, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 70
    0xE0, 0xF8, 0x0C, 0x04, 0x02, 0x02, 0x02, 0x42, 0x44, 0xCC, 0xDE, 0x40, 0x01, 0x07, 0x0E, 0x08, 0x18, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 71
    0x02, 0x02, 0xFE, 0xFE, 0x42, 0x42, 0x40, 0x42, 0x42, 0xFE, 0xFE, 0x02, 0x02, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 72
    0x02, 0x02, 0xFE, 0xFE, 0x02, 0x02, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 73
    0x00, 0x02, 0x02, 0xFE, 0xFE, 0x02, 0x02, 0x18, 0x18, 0x10, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 74
    0x02, 0x02, 0xFE, 0xFE, 0x42, 0xC2, 0xA0, 0x12, 0x0E, 0x06, 0x02, 0x02, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x01, 0x03, 0x16, 0x1C, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 75
    0x02, 0x02, 0xFE, 0xFE, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 76
    0x02, 0x02, 0xFE, 0x0E, 0x7C, 0xF0, 0x80, 0x00, 0x00, 0xC0, 0x30, 0x0C, 0xFE, 0xFE, 0x02, 0x02, 0x10, 0x10, 0x1F, 0x10, 0x10, 0x01, 0x07, 0x1E, 0x06, 0x01, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 77
    0x02, 0x06, 0xFE, 0x1C, 0x38, 0x70, 0xE0, 0x80, 0x02, 0x02, 0xFE, 0x02, 0x02, 0x10, 0x10, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x03, 0x07, 0x0E, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 78
    0xF0, 0xF8, 0x0C, 0x06, 0x02, 0x02, 0x02, 0x06, 0x0C, 0xF8, 0xF0, 0x03, 0x07, 0x0C, 0x18, 0x10, 0x10, 0x10, 0x18, 0x0C, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 79
    0x02, 0x02, 0xFE, 0xFE, 0x82, 0x82, 0x82, 0xC6, 0x7C, 0x38, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
    0xF0, 0xF8, 0x0C, 0x06, 0x02, 0x02, 0x02, 0x06, 0x0C, 0xF8, 0xF0, 0x03, 0x07, 0x0C, 0x18, 0x30, 0x30, 0x70, 0x58, 0x8C, 0x87, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 81
    0x02, 0x02, 0xFE, 0xFE, 0x82, 0x82, 0x82, 0x46, 0x7C, 0x38, 0x00, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x03, 0x06, 0x0C, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 82
    0x38, 0x7C, 0x66, 0xC2, 0xC2, 0x84, 0x9E, 0x00, 0x1E, 0x08, 0x10, 0x10, 0x10, 0x19, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 83
    0x0E, 0x02, 0x02, 0x02, 0xFE, 0xFE, 0x02, 0x02, 0x02, 0x0E, 0x00, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 84
    0x02, 0x02, 0xFE, 0xFE, 0x02, 0x02, 0x00, 0x00, 0x02, 0x02, 0xFE, 0x02, 0x02, 0x00, 0x00, 0x07, 0x0F, 0x18, 0x10, 0x10, 0x10, 0x10, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 85
    0x02, 0x06, 0x1E, 0x7A, 0xE0, 0x00, 0x00, 0x00, 0xE2, 0x1E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x1C, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 86
    0x02, 0x06, 0x1E, 0x7A, 0xE0, 0x80, 0x02, 0x86, 0x7E, 0xF2, 0x80, 0x00, 0x00, 0xE2, 0x1E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x1C, 0x03, 0x00, 0x01, 0x0F, 0x1C, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 87
    0x02, 0x02, 0x06, 0x0E, 0x3A, 0x72, 0xC0, 0xA0, 0x12, 0x0A, 0x06, 0x02, 0x02, 0x10, 0x10, 0x18, 0x14, 0x02, 0x01, 0x00, 0x03, 0x17, 0x1C, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 88
    0x02, 0x06, 0x0E, 0x3A, 0x72, 0xC0, 0x80, 0x40, 0x32, 0x0A, 0x06, 0x02, 0x02, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 89
    0x00, 0x0E, 0x06, 0x02, 0x82, 0xE2, 0x72, 0x1A, 0x0E, 0x06, 0x02, 0x10, 0x18, 0x1E, 0x17, 0x11, 0x10, 0x10, 0x10, 0x10, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 90
    0xFF, 0xFF, 0x01, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, // 91
    0x03, 0x1C, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, // 92
    0x01, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0x80, // 93
    0x40, 0x30, 0x0C, 0x02, 0x02, 0x0C, 0x30, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, // 95
    0x02, 0x06, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 96
    0xC0, 0xE0, 0x20, 0x20, 0xE0, 0xC0, 0x00, 0x0C, 0x1E, 0x12, 0x11, 0x1F, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 97
    0x02, 0xFF, 0xFF, 0x40, 0x20, 0x60, 0xE0, 0xC0, 0x00, 0x0F, 0x1F, 0x10, 0x10, 0x18, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 98
    0x80, 0xC0, 0x20, 0x20, 0xE0, 0xC0, 0x07, 0x0F, 0x1C, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 99
    0x80, 0xC0, 0x60, 0x20, 0x42, 0xFF, 0xFF, 0x00, 0x07, 0x0F, 0x18, 0x10, 0x08, 0x1F, 0x1F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 100
    0x80, 0xC0, 0xA0, 0xA0, 0xE0, 0xC0, 0x07, 0x0F, 0x1C, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 101
    0x20, 0xFC, 0xFE, 0x21, 0x21, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 102
    0xC0, 0xE0, 0x20, 0x20, 0xC0, 0xC0, 0x40, 0xD9, 0x37, 0x34, 0x34, 0x37, 0xB1, 0x60, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, // 103
    0x02, 0xFF, 0xFF, 0x40, 0x20, 0x20, 0xE0, 0xC0, 0x00, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 104
    0x40, 0xE3, 0xE3, 0x00, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, // 105
    0x00, 0x40, 0xE3, 0xE3, 0x80, 0x00, 0xFF, 0x7F, 0x80, 0x80, 0x00, 0x00, // 106
    0x02, 0xFF, 0xFF, 0x00, 0x00, 0xA0, 0x60, 0x20, 0x00, 0x10, 0x1F, 0x1F, 0x11, 0x03, 0x16, 0x1C, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 107
    0x02, 0xFF, 0xFF, 0x00, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, // 108
    0x40, 0xE0, 0xE0, 0x40, 0x20, 0x20, 0xE0, 0xC0, 0x40, 0x20, 0x20, 0xE0, 0xC0, 0x00, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 109
    0x40, 0xE0, 0xE0, 0x40, 0x20, 0x20, 0xE0, 0xC0, 0x00, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 110
    0x80, 0xC0, 0x20, 0x20, 0x60, 0xC0, 0x80, 0x07, 0x0F, 0x18, 0x10, 0x10, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 111
    0x40, 0xE0, 0xE0, 0x40, 0x20, 0x60, 0xE0, 0xC0, 0x00, 0xFF, 0xFF, 0x10, 0x10, 0x18, 0x0F, 0x07, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, // 112
    0x80, 0xC0, 0x60, 0x20, 0x20, 0xC0, 0xE0, 0x00, 0x0F, 0x1F, 0x18, 0x10, 0x08, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, // 113
    0x40, 0xE0, 0xE0, 0x40, 0x20, 0x60, 0x10, 0x1F, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 114
    0xC0, 0xA0, 0x20, 0x20, 0x60, 0x19, 0x13, 0x13, 0x17, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, // 115
    0x20, 0xF0, 0xFC, 0x20, 0x20, 0x00, 0x0F, 0x1F, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, // 116
    0x20, 0xE0, 0xE0, 0x00, 0x00, 0x20, 0xE0, 0xE0, 0x00, 0x00, 0x0F, 0x1F, 0x10, 0x10, 0x08, 0x1F, 0x1F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 117
    0x20, 0x60, 0xE0, 0xA0, 0x00, 0x00, 0xA0, 0x60, 0x20, 0x00, 0x00, 0x03, 0x0F, 0x1C, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 118
    0x20, 0xE0, 0xE0, 0x20, 0x00, 0x20, 0xE0, 0xE0, 0x20, 0x00, 0x20, 0xE0, 0x20, 0x00, 0x00, 0x03, 0x0F, 0x1C, 0x06, 0x01, 0x03, 0x0F, 0x1C, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 119
    0x20, 0x60, 0xE0, 0xA0, 0x80, 0x60, 0x20, 0x20, 0x10, 0x18, 0x14, 0x03, 0x17, 0x1C, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 120
    0x20, 0xE0, 0xE0, 0x20, 0x00, 0x00, 0x20, 0xE0, 0x20, 0x00, 0x80, 0x83, 0xCF, 0x3C, 0x0C, 0x03, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 121
    0x00, 0x60, 0x20, 0x20, 0xA0, 0xE0, 0x60, 0x20, 0x10, 0x18, 0x1C, 0x17, 0x13, 0x10, 0x10, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 122
    0x00, 0x80, 0xFC, 0x7E, 0x03, 0x01, 0x01, 0x02, 0x7E, 0xFC, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, // 123
    0xFF, 0xFF, 0x80, // 124
    0x01, 0x03, 0x7E, 0xFC, 0x80, 0x00, 0x00, 0x80, 0xFC, 0x7E, 0x02, 0x01, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, // 125
    0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x01, 0x01, 0x03, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFE, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 // 127
    
};

#endif
