#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef SYSTEM5X8_H
#define SYSTEM5X8_H

const static uint8_t SystemFont5x8[] PROGMEM = {
	0x0, 0x0, // size of zero indicates fixed width font, actual length is width * height
	0x05, // width
	0x08, // height
	0x20, // first char
	0x60, // char count

	// Fixed width; char width table not used !!!!

	// font data

	0x00, 0x00, 0x00, 0x00, 0x00,// (space)
	0x00, 0x00, 0x5F, 0x00, 0x00,// !
	0x00, 0x07, 0x00, 0x07, 0x00,// "
	0x14, 0x7F, 0x14, 0x7F, 0x14,// #
	0x24, 0x2A, 0x7F, 0x2A, 0x12,// $
	0x23, 0x13, 0x08, 0x64, 0x62,// %
	0x36, 0x49, 0x55, 0x22, 0x50,// &
	0x00, 0x05, 0x03, 0x00, 0x00,// '
	0x00, 0x1C, 0x22, 0x41, 0x00,// (
	0x00, 0x41, 0x22, 0x1C, 0x00,// )
	0x08, 0x2A, 0x1C, 0x2A, 0x08,// *
	0x08, 0x08, 0x3E, 0x08, 0x08,// +
	0x00, 0x50, 0x30, 0x00, 0x00,// ,
	0x08, 0x08, 0x08, 0x08, 0x08,// -
	0x00, 0x60, 0x60, 0x00, 0x00,// .
	0x20, 0x10, 0x08, 0x04, 0x02,// /


	///////////////////////////////////
	0x7E, 0xFF, 0x81, 0xFF, 0x7E,            // Code for char 0
	0x0C, 0x06, 0xFF, 0xFF, 0x00,            // Code for char 1
	0xC2, 0xE3, 0xB1, 0x9F, 0x8E,            // Code for char 2
	0x42, 0xC3, 0x89, 0xFF, 0x76,            // Code for char 3
	0x30, 0x2C, 0x22, 0xFF, 0xFF,            // Code for char 4
	0x5C, 0xCF, 0x8B, 0xF9, 0x71,            // Code for char 5
	0x7E, 0xFF, 0x89, 0xFB, 0x72,            // Code for char 6
	0x01, 0xF1, 0xFD, 0x0F, 0x03,            // Code for char 7
	0x76, 0xFF, 0x89, 0xFF, 0x76,            // Code for char 8
	0x4E, 0xDF, 0x91, 0xFF, 0x7E,            // Code for char 9



	//////////////////////////////////////////
	0x00, 0x00, 0x66, 0x00, 0x00,            // Code for char :
	0x00, 0x66, 0x66, 0x66, 0x00,            // Code for char ;
	0x00, 0x08, 0x14, 0x22, 0x41,// <
	0x14, 0x14, 0x14, 0x14, 0x14,// =
	0x41, 0x22, 0x14, 0x08, 0x00,// >
	0x02, 0x01, 0x51, 0x09, 0x06,// ?
	0x32, 0x49, 0x79, 0x41, 0x3E,// @
	0xFE, 0xFF, 0x11, 0x11, 0xFE,            // Code for char A
	0xFF, 0xFF, 0x91, 0x99, 0x76,            // Code for char B
	0x7E, 0xFF, 0x81, 0x81, 0xC3,            // Code for char C
	0xFF, 0xFF, 0x81, 0x81, 0x7E,            // Code for char D
	0xFF, 0xFF, 0x99, 0x81, 0xC3,            // Code for char E
	0xFF, 0xFF, 0x13, 0x13, 0x03,            // Code for char F
	0x7E, 0xFF, 0x81, 0x89, 0xF9,            // Code for char G
	0xFF, 0xFF, 0x10, 0x10, 0xFF,            // Code for char H
	0x81, 0xFF, 0xFF, 0x81, 0x00,            // Code for char I
	0x41, 0x81, 0x81, 0xFF, 0xFF,            // Code for char J
	0xFF, 0xFF, 0x3C, 0x66, 0xC3,            // Code for char K
	0xFF, 0xFF, 0x80, 0x80, 0xC0,            // Code for char L
	0xFF, 0x03, 0xFF, 0x03, 0xFF,            // Code for char M
	0xFF, 0xFF, 0x0E, 0x18, 0xFF,            // Code for char N
	0x7E, 0xFF, 0x81, 0x81, 0x7E,            // Code for char O
	0xFF, 0xFF, 0x21, 0x21, 0x1E,            // Code for char P
	0x7E, 0xFF, 0x81, 0xE1, 0xFE,            // Code for char Q
	0xFF, 0xFF, 0x31, 0x71, 0xCE,            // Code for char R
	0x46, 0x8F, 0x91, 0xF1, 0x62,            // Code for char S
	0x03, 0x03, 0xFF, 0x03, 0x03,            // Code for char T
	0x7F, 0xFF, 0x80, 0x80, 0x7F,            // Code for char U
	0x1F, 0x70, 0xC0, 0x70, 0x1F,            // Code for char V
	0xFF, 0xC0, 0xFF, 0xC0, 0xFF,            // Code for char W
	0xC3, 0x3E, 0x18, 0x3E, 0xC3,            // Code for char X
	0x07, 0x0C, 0xF8, 0x0C, 0x07,            // Code for char Y
	0xE1, 0xB1, 0x99, 0x8F, 0x8F,            // Code for char Z
	0x00, 0x00, 0x7F, 0x41, 0x41,// [
	0x02, 0x04, 0x08, 0x10, 0x20,// "\"
	0x41, 0x41, 0x7F, 0x00, 0x00,// ]
	0x04, 0x02, 0x01, 0x02, 0x04,// ^
	0x40, 0x40, 0x40, 0x40, 0x40,// _
	0x00, 0x01, 0x02, 0x04, 0x00,// `
	0x20, 0x54, 0x54, 0x54, 0x78,// a
	0x7F, 0x48, 0x44, 0x44, 0x38,// b
	0x38, 0x44, 0x44, 0x44, 0x20,// c
	0x38, 0x44, 0x44, 0x48, 0x7F,// d
	0x38, 0x54, 0x54, 0x54, 0x18,// e
	0x08, 0x7E, 0x09, 0x01, 0x02,// f
	0x08, 0x14, 0x54, 0x54, 0x3C,// g
	0x7F, 0x08, 0x04, 0x04, 0x78,// h
	0x00, 0x44, 0x7D, 0x40, 0x00,// i
	0x20, 0x40, 0x44, 0x3D, 0x00,// j
	0x00, 0x7F, 0x10, 0x28, 0x44,// k
	0x00, 0x41, 0x7F, 0x40, 0x00,// l
	0x7C, 0x04, 0x18, 0x04, 0x78,// m
	0x7C, 0x08, 0x04, 0x04, 0x78,// n
	0x38, 0x44, 0x44, 0x44, 0x38,// o
	0x7C, 0x14, 0x14, 0x14, 0x08,// p
	0x08, 0x14, 0x14, 0x18, 0x7C,// q
	0x7C, 0x08, 0x04, 0x04, 0x08,// r
	0x48, 0x54, 0x54, 0x54, 0x20,// s
	0x04, 0x3F, 0x44, 0x40, 0x20,// t
	0x3C, 0x40, 0x40, 0x20, 0x7C,// u
	0x1C, 0x20, 0x40, 0x20, 0x1C,// v
	0x3C, 0x40, 0x30, 0x40, 0x3C,// w
	0x44, 0x28, 0x10, 0x28, 0x44,// x
	0x0C, 0x50, 0x50, 0x50, 0x3C,// y
	0x44, 0x64, 0x54, 0x4C, 0x44,// z
	0x00, 0x08, 0x36, 0x41, 0x00,// {
	0x00, 0x00, 0x7F, 0x00, 0x00,// |
	0x00, 0x41, 0x36, 0x08, 0x00,// }
	0x08, 0x08, 0x2A, 0x1C, 0x08,// ->
	0x08, 0x1C, 0x2A, 0x08, 0x08 // <-
	
    
};

#endif
