

/*
 *
 * new Font
 *
 * created with FontCreator
 * written by F. Maximilian Thiele
 *
 * http://www.apetech.de/fontCreator
 * me@apetech.de
 *
 * File Name           : BodoniBlack16.h
 * Date                : 15.03.2018
 * Font size in bytes  : 13446
 * Font width          : 10
 * Font height         : 16
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef BODONIBLACK_H
#define BODONIBLACK_H

#define BODONIBLACK_WIDTH 10
#define BODONIBLACK_HEIGHT 16

const static uint8_t BodoniBlack16[] PROGMEM = {
    0x34, 0x86, // size
    0x0A, // width
    0x10, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x03, 0x05, 0x0A, 0x09, 0x0E, 0x0E, 0x02, 0x05, 0x05, 
    0x03, 0x08, 0x03, 0x05, 0x03, 0x08, 0x09, 0x06, 0x09, 0x09, 
    0x0A, 0x09, 0x09, 0x0A, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 
    0x09, 0x07, 0x0E, 0x0B, 0x0C, 0x0A, 0x0D, 0x0B, 0x0A, 0x0C, 
    0x0D, 0x06, 0x09, 0x0E, 0x0A, 0x10, 0x0D, 0x0C, 0x0C, 0x0C, 
    0x0D, 0x09, 0x0A, 0x0B, 0x0B, 0x12, 0x0C, 0x0C, 0x0A, 0x04, 
    0x08, 0x05, 0x07, 0x08, 0x03, 0x0A, 0x09, 0x07, 0x0A, 0x08, 
    0x06, 0x08, 0x0B, 0x06, 0x05, 0x0B, 0x06, 0x0F, 0x0B, 0x09, 
    0x09, 0x0A, 0x07, 0x07, 0x06, 0x0B, 0x08, 0x0D, 0x08, 0x08, 
    0x07, 0x04, 0x02, 0x04, 0x09, 0x0C, 
    
    // font data
    0x3C, 0xFC, 0x3C, 0x0C, 0x0D, 0x0C, // 33
    0x7C, 0x1C, 0x00, 0x7C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0xB0, 0xB0, 0xF0, 0xFC, 0xBC, 0xB0, 0xF0, 0xFC, 0xBC, 0xB0, 0x01, 0x0F, 0x0F, 0x01, 0x01, 0x0F, 0x0F, 0x01, 0x01, 0x01, // 35
    0x30, 0x78, 0xFC, 0xF4, 0xFE, 0xE4, 0xDC, 0xDC, 0x98, 0x06, 0x0E, 0x0E, 0x08, 0x1F, 0x09, 0x0F, 0x07, 0x03, // 36
    0x78, 0xFC, 0x84, 0xFC, 0x78, 0x00, 0x80, 0x60, 0x18, 0x84, 0xC0, 0x40, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x08, 0x06, 0x01, 0x00, 0x00, 0x07, 0x0F, 0x08, 0x0F, 0x07, // 37
    0x00, 0x80, 0xC0, 0x40, 0x38, 0xFC, 0xFC, 0xFC, 0xE4, 0x98, 0x40, 0xC0, 0x40, 0x00, 0x07, 0x07, 0x0F, 0x0F, 0x0C, 0x08, 0x09, 0x0B, 0x07, 0x0F, 0x0F, 0x0C, 0x08, 0x04, // 38
    0x7C, 0x1C, 0x00, 0x00, // 39
    0xC0, 0xF0, 0xF8, 0xF8, 0x04, 0x07, 0x1F, 0x3F, 0x3F, 0x40, // 40
    0x04, 0xF8, 0xF8, 0xF0, 0xC0, 0x40, 0x3F, 0x3F, 0x1F, 0x07, // 41
    0x14, 0x3C, 0x14, 0x00, 0x00, 0x00, // 42
    0xC0, 0xC0, 0xC0, 0xF8, 0xF8, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x0C, 0x2C, 0x1C, // 44
    0x80, 0x80, 0x80, 0x80, 0x80, 0x03, 0x03, 0x03, 0x03, 0x03, // 45
    0x00, 0x00, 0x00, 0x0C, 0x0C, 0x0C, // 46
    0x00, 0x00, 0x00, 0x80, 0xE0, 0x78, 0x1C, 0x04, 0x20, 0x38, 0x1E, 0x07, 0x01, 0x00, 0x00, 0x00, // 47
    0xE0, 0xF8, 0xF8, 0xFC, 0x04, 0xFC, 0xF8, 0xF8, 0xE0, 0x01, 0x07, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x07, 0x01, // 48
    0x08, 0xF8, 0xF8, 0xF8, 0xFC, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 49
    0x38, 0x38, 0x3C, 0x04, 0x0C, 0xFC, 0xFC, 0x78, 0x70, 0x08, 0x0C, 0x0E, 0x0F, 0x0F, 0x0E, 0x0E, 0x06, 0x02, // 50
    0x18, 0x1C, 0x1C, 0x44, 0x44, 0xFC, 0xBC, 0xB8, 0x38, 0x07, 0x0F, 0x0B, 0x08, 0x08, 0x0F, 0x0F, 0x07, 0x07, // 51
    0x00, 0x00, 0xC0, 0x20, 0x10, 0xFC, 0xFC, 0xFC, 0xFC, 0x00, 0x02, 0x03, 0x02, 0x02, 0x0A, 0x0F, 0x0F, 0x0F, 0x0F, 0x0A, // 52
    0x00, 0xF8, 0x5C, 0x5C, 0x5C, 0xDC, 0xDC, 0x8C, 0x84, 0x06, 0x0E, 0x0E, 0x08, 0x08, 0x0F, 0x0F, 0x07, 0x03, // 53
    0xE0, 0xF0, 0xF8, 0xFC, 0x84, 0xDC, 0xDC, 0xD8, 0x80, 0x03, 0x07, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x07, 0x03, // 54
    0x20, 0x1C, 0x1C, 0x1C, 0x9C, 0xDC, 0xFC, 0x3C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x07, 0x0F, 0x0F, 0x07, 0x00, 0x00, 0x00, // 55
    0x38, 0xBC, 0xBC, 0xFC, 0x44, 0xFC, 0xBC, 0xBC, 0xB8, 0x07, 0x07, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x07, 0x03, // 56
    0x70, 0xF8, 0xFC, 0xFC, 0x84, 0xFC, 0xFC, 0xF8, 0xF0, 0x06, 0x0E, 0x0E, 0x08, 0x08, 0x0F, 0x07, 0x03, 0x01, // 57
    0x60, 0x60, 0x60, 0x0C, 0x0C, 0x0C, // 58
    0x60, 0x60, 0x60, 0x0C, 0x2C, 0x1C, // 59
    0xE0, 0xE0, 0xE0, 0xB0, 0xB0, 0xB8, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x03, 0x03, 0x06, // 60
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, // 61
    0x0C, 0x18, 0x18, 0xB8, 0xB0, 0xB0, 0xE0, 0xE0, 0xE0, 0x06, 0x03, 0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, // 62
    0x38, 0x34, 0x84, 0xCC, 0xFC, 0xF8, 0x70, 0x00, 0x0C, 0x0D, 0x0D, 0x01, 0x00, 0x00, // 63
    0xC0, 0x20, 0x10, 0x08, 0xC4, 0xC4, 0x24, 0xA4, 0xE4, 0x64, 0x08, 0x18, 0xE0, 0x00, 0x07, 0x18, 0x20, 0x2F, 0x4F, 0x4C, 0x42, 0x4F, 0x4F, 0x48, 0x2C, 0x26, 0x11, 0x08, // 64
    0x00, 0x00, 0x80, 0x70, 0x0C, 0x7C, 0xFC, 0xFC, 0xF0, 0x80, 0x00, 0x08, 0x0C, 0x0F, 0x09, 0x01, 0x09, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 65
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x44, 0x44, 0x44, 0xFC, 0xFC, 0xFC, 0x98, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x08, 0x08, 0x0F, 0x0F, 0x0F, 0x07, // 66
    0xE0, 0xF8, 0xF8, 0xFC, 0x04, 0x04, 0x04, 0x04, 0x08, 0x3C, 0x01, 0x07, 0x07, 0x0F, 0x08, 0x08, 0x08, 0x08, 0x04, 0x02, // 67
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x04, 0x04, 0x04, 0xFC, 0xFC, 0xF8, 0xE0, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x08, 0x08, 0x08, 0x0F, 0x0F, 0x07, 0x01, // 68
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x44, 0x44, 0xF4, 0x04, 0x0C, 0x1C, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x08, 0x09, 0x08, 0x0C, 0x0E, // 69
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x44, 0x44, 0xF4, 0x0C, 0x1C, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x01, 0x00, 0x00, // 70
    0xE0, 0xF0, 0xF8, 0xFC, 0x04, 0x04, 0x84, 0x84, 0x84, 0x88, 0xBC, 0x80, 0x01, 0x03, 0x07, 0x0F, 0x08, 0x08, 0x08, 0x0F, 0x0F, 0x07, 0x0F, 0x00, // 71
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x44, 0x40, 0x44, 0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 72
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 73
    0x00, 0x00, 0x00, 0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x07, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x0F, 0x07, 0x00, // 74
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x44, 0xE0, 0xE4, 0xF4, 0xCC, 0x8C, 0x04, 0x04, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x01, 0x03, 0x0F, 0x0F, 0x0F, 0x0E, 0x0C, 0x08, // 75
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x08, 0x08, 0x0C, 0x0E, // 76
    0x00, 0x04, 0xFC, 0x1C, 0xFC, 0xFC, 0xFC, 0xE0, 0x80, 0x60, 0x18, 0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x08, 0x0C, 0x0F, 0x08, 0x00, 0x07, 0x0F, 0x07, 0x01, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 77
    0x04, 0x04, 0xFC, 0x3C, 0x7C, 0xFC, 0xF0, 0xE0, 0xC4, 0x0C, 0xFC, 0x0C, 0x04, 0x08, 0x0C, 0x0F, 0x0C, 0x08, 0x00, 0x03, 0x07, 0x0F, 0x0F, 0x0F, 0x00, 0x00, // 78
    0xE0, 0xF8, 0xF8, 0xFC, 0x04, 0x04, 0x04, 0x04, 0xFC, 0xF8, 0xF8, 0xE0, 0x01, 0x07, 0x07, 0x0F, 0x08, 0x08, 0x08, 0x08, 0x0F, 0x07, 0x07, 0x01, // 79
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x84, 0x84, 0x84, 0xFC, 0xFC, 0x7C, 0x38, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
    0xE0, 0xF8, 0xF8, 0xFC, 0x04, 0x04, 0x04, 0x04, 0xFC, 0xF8, 0xF8, 0xE0, 0x01, 0x03, 0x07, 0x0F, 0x08, 0x38, 0x78, 0xF8, 0xCF, 0x87, 0x87, 0x01, // 81
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x44, 0x44, 0x44, 0xFC, 0xFC, 0xBC, 0xB8, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x00, 0x07, 0x0F, 0x0F, 0x0F, 0x08, // 82
    0x30, 0x78, 0xFC, 0xE4, 0xE4, 0xC4, 0xC4, 0x88, 0x9C, 0x0E, 0x04, 0x08, 0x08, 0x09, 0x09, 0x0F, 0x07, 0x03, // 83
    0x1C, 0x0C, 0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x0C, 0x1C, 0x00, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x00, // 84
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x04, 0x00, 0x00, 0x04, 0xFC, 0x04, 0x00, 0x07, 0x0F, 0x0F, 0x0F, 0x08, 0x08, 0x08, 0x0C, 0x07, 0x00, // 85
    0x04, 0x1C, 0xFC, 0xFC, 0xFC, 0xE4, 0x00, 0xC4, 0x3C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x07, 0x0F, 0x0F, 0x0F, 0x01, 0x00, 0x00, 0x00, // 86
    0x04, 0x1C, 0xFC, 0xFC, 0xFC, 0xE4, 0x04, 0x1C, 0xFC, 0xFC, 0xFC, 0xE4, 0x00, 0x00, 0xC4, 0x3C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x07, 0x0F, 0x0F, 0x07, 0x02, 0x01, 0x07, 0x0F, 0x0F, 0x0F, 0x06, 0x01, 0x00, 0x00, 0x00, // 87
    0x00, 0x04, 0x0C, 0x1C, 0xFC, 0xFC, 0xFC, 0xE0, 0xE4, 0x1C, 0x0C, 0x04, 0x08, 0x0C, 0x0E, 0x09, 0x00, 0x01, 0x0F, 0x0F, 0x0F, 0x0F, 0x0C, 0x08, // 88
    0x04, 0x0C, 0x3C, 0x7C, 0xFC, 0xF4, 0xE0, 0x80, 0x44, 0x3C, 0x0C, 0x04, 0x00, 0x00, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x00, 0x00, // 89
    0x00, 0x1C, 0x0C, 0xC4, 0xF4, 0xFC, 0xFC, 0x3C, 0x1C, 0x04, 0x08, 0x0E, 0x0F, 0x0F, 0x0F, 0x0B, 0x08, 0x0C, 0x0C, 0x0E, // 90
    0xFC, 0xFC, 0xFC, 0x04, 0x7F, 0x7F, 0x7F, 0x40, // 91
    0x04, 0x1C, 0x78, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x1E, 0x38, 0x20, // 92
    0x04, 0x04, 0xFC, 0xFC, 0xFC, 0x40, 0x40, 0x7F, 0x7F, 0x7F, // 93
    0x80, 0xE0, 0x38, 0x0C, 0x38, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, // 95
    0x04, 0x0C, 0x08, 0x00, 0x00, 0x00, // 96
    0x00, 0x60, 0x60, 0x60, 0x20, 0xE0, 0xE0, 0xE0, 0xC0, 0x00, 0x06, 0x0F, 0x0F, 0x0F, 0x09, 0x07, 0x0F, 0x0F, 0x0F, 0x08, // 97
    0xFC, 0xFC, 0xFC, 0xFC, 0x40, 0xE0, 0xE0, 0xC0, 0x80, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x07, 0x03, // 98
    0x80, 0xC0, 0xE0, 0xE0, 0x20, 0xE0, 0xC0, 0x03, 0x07, 0x0F, 0x0F, 0x08, 0x08, 0x04, // 99
    0x80, 0xC0, 0xE0, 0xE0, 0x44, 0xFC, 0xFC, 0xFC, 0xFC, 0x00, 0x03, 0x07, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 100
    0x80, 0xC0, 0xE0, 0xE0, 0x20, 0xE0, 0xC0, 0x80, 0x03, 0x07, 0x0F, 0x0F, 0x09, 0x09, 0x09, 0x05, // 101
    0x20, 0xF8, 0xFC, 0xE4, 0xEC, 0x2C, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 102
    0xC0, 0xE0, 0xE0, 0xE0, 0x20, 0xF0, 0xD8, 0xD8, 0x79, 0xBD, 0xBB, 0xBB, 0xBA, 0xBB, 0x7B, 0x71, // 103
    0xFC, 0xFC, 0xFC, 0xFC, 0x40, 0x20, 0xE0, 0xE0, 0xE0, 0xC0, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 104
    0x20, 0xEC, 0xEC, 0xEC, 0xEC, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 105
    0x20, 0xEC, 0xEC, 0xEC, 0xEC, 0xE0, 0xEF, 0x8F, 0xDF, 0x7F, // 106
    0xFC, 0xFC, 0xFC, 0xFC, 0x00, 0x80, 0xE0, 0xA0, 0x20, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x09, 0x03, 0x0F, 0x0F, 0x0F, 0x0E, 0x08, // 107
    0x04, 0xFC, 0xFC, 0xFC, 0xFC, 0x00, 0x08, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 108
    0xE0, 0xE0, 0xE0, 0xE0, 0x40, 0xE0, 0xE0, 0xE0, 0xC0, 0x40, 0xE0, 0xE0, 0xE0, 0xC0, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 109
    0xE0, 0xE0, 0xE0, 0xE0, 0x40, 0x20, 0xE0, 0xE0, 0xE0, 0xC0, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 110
    0x80, 0xC0, 0xE0, 0xE0, 0x20, 0xE0, 0xE0, 0xC0, 0x80, 0x03, 0x07, 0x0F, 0x0F, 0x08, 0x0F, 0x0F, 0x07, 0x03, // 111
    0xE0, 0xE0, 0xE0, 0xE0, 0x40, 0xE0, 0xE0, 0xC0, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x0F, 0x0F, 0x07, 0x03, // 112
    0x80, 0xC0, 0xE0, 0xE0, 0x40, 0xE0, 0xE0, 0xE0, 0xE0, 0x20, 0x03, 0x07, 0x0F, 0x0F, 0x88, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, // 113
    0xE0, 0xE0, 0xE0, 0xE0, 0x40, 0xE0, 0xE0, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x00, // 114
    0xC0, 0xE0, 0xE0, 0xA0, 0xA0, 0x20, 0x60, 0x0C, 0x09, 0x0B, 0x0B, 0x0F, 0x0F, 0x06, // 115
    0xE0, 0xF0, 0xF8, 0xFC, 0x20, 0x00, 0x07, 0x0F, 0x0F, 0x0F, 0x08, 0x04, // 116
    0xE0, 0xE0, 0xE0, 0xE0, 0x00, 0x20, 0xE0, 0xE0, 0xE0, 0xE0, 0x00, 0x07, 0x0F, 0x0F, 0x0F, 0x08, 0x04, 0x0F, 0x0F, 0x0F, 0x0F, 0x08, // 117
    0xE0, 0xE0, 0xE0, 0xE0, 0x00, 0x00, 0xE0, 0x20, 0x00, 0x03, 0x0F, 0x0F, 0x0F, 0x03, 0x00, 0x00, // 118
    0xE0, 0xE0, 0xE0, 0xE0, 0x00, 0x20, 0xE0, 0xE0, 0xE0, 0xE0, 0x00, 0xE0, 0x60, 0x00, 0x03, 0x0F, 0x0F, 0x0F, 0x06, 0x01, 0x07, 0x0F, 0x0F, 0x0F, 0x03, 0x00, // 119
    0x20, 0x60, 0xE0, 0xE0, 0xA0, 0x80, 0x60, 0x20, 0x08, 0x0C, 0x03, 0x0B, 0x0F, 0x0F, 0x0E, 0x08, // 120
    0xE0, 0xE0, 0xE0, 0xE0, 0x80, 0x00, 0xE0, 0x20, 0xE0, 0xE1, 0x67, 0x1F, 0x07, 0x03, 0x00, 0x00, // 121
    0x60, 0x20, 0xE0, 0xE0, 0xE0, 0xE0, 0x20, 0x08, 0x0E, 0x0F, 0x0F, 0x0F, 0x08, 0x0C, // 122
    0x00, 0xF8, 0xFC, 0x04, 0x01, 0x3E, 0x7E, 0x40, // 123
    0xFE, 0xFE, 0x3F, 0x3F, // 124
    0x04, 0xFC, 0xF8, 0x00, 0x40, 0x7C, 0x3E, 0x01, // 125
    0xC0, 0x60, 0x60, 0x60, 0xE0, 0xC0, 0xC0, 0xC0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFF, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF, 0x0F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0F // 127
    
};

#endif
