

/*
 *
 * new Font
 *
 * created with FontCreator
 * written by F. Maximilian Thiele
 *
 * http://www.apetech.de/fontCreator
 * me@apetech.de
 *
 * File Name           : ArialBlack11.h
 * Date                : 08.03.2018
 * Font size in bytes  : 5668
 * Font width          : 10
 * Font height         : 11
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef ARIALBLACK11_H
#define ARIALBLACK11_H

#define ARIALBLACK11_WIDTH 10
#define ARIALBLACK11_HEIGHT 11

const static uint8_t ArialBlack11[] PROGMEM = {
    0x16, 0x24, // size
    0x0A, // width
    0x0B, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x02, 0x05, 0x07, 0x05, 0x09, 0x08, 0x02, 0x03, 0x03, 
    0x03, 0x06, 0x02, 0x03, 0x02, 0x03, 0x05, 0x05, 0x05, 0x05, 
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x02, 0x06, 0x05, 
    0x06, 0x06, 0x08, 0x09, 0x07, 0x07, 0x07, 0x06, 0x05, 0x07, 
    0x07, 0x02, 0x06, 0x08, 0x05, 0x08, 0x07, 0x07, 0x06, 0x07, 
    0x08, 0x06, 0x06, 0x07, 0x09, 0x0B, 0x09, 0x08, 0x06, 0x03, 
    0x03, 0x03, 0x06, 0x06, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05, 
    0x04, 0x05, 0x05, 0x02, 0x03, 0x06, 0x02, 0x08, 0x05, 0x05, 
    0x05, 0x05, 0x04, 0x05, 0x04, 0x05, 0x07, 0x09, 0x07, 0x07, 
    0x04, 0x04, 0x01, 0x04, 0x06, 0x06, 
    
    // font data
    0xBE, 0xBE, 0x20, 0x20, // 33
    0x0E, 0x0E, 0x00, 0x0E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0xD8, 0xF8, 0xFE, 0xDE, 0xF8, 0xFE, 0xDE, 0x20, 0x20, 0x00, 0x20, 0x20, 0x00, 0x00, // 35
    0x8C, 0x9E, 0xFF, 0xF6, 0xE4, 0x00, 0x20, 0x60, 0x20, 0x00, // 36
    0x0C, 0x12, 0x12, 0xCC, 0x30, 0xCC, 0x22, 0x20, 0xC0, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, // 37
    0xC0, 0xEC, 0xBE, 0xB6, 0xFE, 0xEC, 0xE0, 0xA0, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x20, // 38
    0x0E, 0x0E, 0x00, 0x00, // 39
    0xF8, 0xFC, 0x02, 0x20, 0x60, 0x80, // 40
    0x02, 0xFC, 0xF8, 0x80, 0x60, 0x20, // 41
    0x14, 0x0E, 0x14, 0x00, 0x00, 0x00, // 42
    0x30, 0x30, 0xFC, 0xFC, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 43
    0x80, 0x80, 0xA0, 0x60, // 44
    0x60, 0x60, 0x60, 0x00, 0x00, 0x00, // 45
    0x80, 0x80, 0x20, 0x20, // 46
    0x80, 0x78, 0x06, 0x20, 0x00, 0x00, // 47
    0xFC, 0xFE, 0x86, 0xFE, 0xFC, 0x00, 0x20, 0x20, 0x20, 0x00, // 48
    0x18, 0x0C, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, // 49
    0x8C, 0xCE, 0xE6, 0xBE, 0x9C, 0x20, 0x20, 0x20, 0x20, 0x20, // 50
    0xC4, 0xC6, 0x96, 0xFE, 0xEC, 0x00, 0x20, 0x20, 0x20, 0x00, // 51
    0xE0, 0xF0, 0xDC, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x20, 0x20, // 52
    0xB8, 0xBE, 0xB6, 0xF6, 0xE6, 0x00, 0x20, 0x20, 0x20, 0x00, // 53
    0xFC, 0xFE, 0xB6, 0xF6, 0xE4, 0x00, 0x20, 0x20, 0x20, 0x00, // 54
    0x06, 0xC6, 0xF6, 0x3E, 0x06, 0x00, 0x20, 0x20, 0x00, 0x00, // 55
    0xEC, 0xFE, 0xB6, 0xFE, 0xEC, 0x00, 0x20, 0x20, 0x20, 0x00, // 56
    0x9C, 0xBE, 0xB6, 0xFE, 0xFC, 0x00, 0x20, 0x20, 0x20, 0x00, // 57
    0x98, 0x98, 0x20, 0x20, // 58
    0x98, 0x98, 0xA0, 0x60, // 59
    0x70, 0x70, 0xD8, 0xD8, 0xD8, 0x8C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, // 60
    0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00, // 61
    0x8C, 0xD8, 0xD8, 0xD8, 0x70, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, // 62
    0x0C, 0x0E, 0x66, 0x76, 0x3E, 0x1C, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, // 63
    0xF8, 0x04, 0xF2, 0x8A, 0xFA, 0x9A, 0x44, 0x38, 0x00, 0x20, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, // 64
    0x00, 0xE0, 0xF8, 0xDE, 0xC6, 0xDE, 0xF8, 0xE0, 0x00, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, // 65
    0xFE, 0xFE, 0xB6, 0xB6, 0xB6, 0xFE, 0xEC, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, // 66
    0x78, 0xFC, 0x86, 0x86, 0x86, 0xCE, 0xCC, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, // 67
    0xFE, 0xFE, 0x86, 0x86, 0x86, 0xFC, 0x78, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, // 68
    0xFE, 0xFE, 0xB6, 0xB6, 0xB6, 0xB6, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, // 69
    0xFE, 0xFE, 0x36, 0x36, 0x06, 0x20, 0x20, 0x00, 0x00, 0x00, // 70
    0x78, 0xFC, 0x86, 0x86, 0xA6, 0xEE, 0xEC, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, // 71
    0xFE, 0xFE, 0x30, 0x30, 0x30, 0xFE, 0xFE, 0x20, 0x20, 0x00, 0x00, 0x00, 0x20, 0x20, // 72
    0xFE, 0xFE, 0x20, 0x20, // 73
    0xC0, 0xC0, 0x80, 0x80, 0xFE, 0xFE, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, // 74
    0xFE, 0xFE, 0x10, 0x18, 0x7C, 0xE6, 0x82, 0x00, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, // 75
    0xFE, 0xFE, 0x80, 0x80, 0x80, 0x20, 0x20, 0x20, 0x20, 0x20, // 76
    0xFE, 0xFE, 0x3C, 0xE0, 0xE0, 0x3C, 0xFE, 0xFE, 0x20, 0x20, 0x00, 0x20, 0x20, 0x00, 0x20, 0x20, // 77
    0xFE, 0xFE, 0x1C, 0x30, 0xE0, 0xFE, 0xFE, 0x20, 0x20, 0x00, 0x00, 0x00, 0x20, 0x20, // 78
    0x78, 0xFC, 0x86, 0x86, 0x86, 0xFC, 0x78, 0x00, 0x00, 0x20, 0x20, 0x20, 0x00, 0x00, // 79
    0xFE, 0xFE, 0x66, 0x66, 0x7E, 0x3C, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, // 80
    0x78, 0xFC, 0x86, 0xC6, 0xC6, 0xFC, 0x78, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x60, // 81
    0xFE, 0xFE, 0x36, 0x36, 0x76, 0xFE, 0x9C, 0x00, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, // 82
    0x9C, 0x9E, 0xB6, 0xB6, 0xF6, 0xE4, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, // 83
    0x06, 0x06, 0xFE, 0xFE, 0x06, 0x06, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, // 84
    0xFE, 0xFE, 0x80, 0x80, 0x80, 0xFE, 0xFE, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, // 85
    0x02, 0x1E, 0x7C, 0xF0, 0x80, 0xF0, 0x7C, 0x1E, 0x02, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, // 86
    0x06, 0x3E, 0xF0, 0xE0, 0x7E, 0x0E, 0x7E, 0xE0, 0xF0, 0x3E, 0x06, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, // 87
    0x02, 0x86, 0xEC, 0x78, 0x30, 0x78, 0xEC, 0x86, 0x02, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, // 88
    0x02, 0x06, 0x1C, 0xF8, 0xF8, 0x1C, 0x06, 0x02, 0x00, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00, 0x00, // 89
    0x86, 0xC6, 0xF6, 0xBE, 0x8E, 0x86, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, // 90
    0xFE, 0xFE, 0x06, 0xE0, 0xE0, 0xC0, // 91
    0x06, 0x78, 0x80, 0x00, 0x00, 0x20, // 92
    0x06, 0xFE, 0xFE, 0xC0, 0xE0, 0xE0, // 93
    0x10, 0x1C, 0x0E, 0x0E, 0x1C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, // 95
    0x02, 0x06, 0x04, 0x00, 0x00, 0x00, // 96
    0xD0, 0xD8, 0x28, 0xF8, 0xF0, 0x20, 0x20, 0x20, 0x20, 0x20, // 97
    0xFE, 0xFE, 0x98, 0xF8, 0xF0, 0x20, 0x20, 0x20, 0x20, 0x00, // 98
    0xF0, 0xF8, 0x98, 0x98, 0x90, 0x00, 0x20, 0x20, 0x20, 0x00, // 99
    0xF0, 0xF8, 0x98, 0xFE, 0xFE, 0x00, 0x20, 0x20, 0x20, 0x20, // 100
    0xF0, 0xF8, 0xA8, 0xB8, 0xB0, 0x00, 0x20, 0x20, 0x20, 0x00, // 101
    0x18, 0xFE, 0xFE, 0x1A, 0x00, 0x20, 0x20, 0x00, // 102
    0xF0, 0xF8, 0x98, 0xF8, 0xF8, 0x80, 0xA0, 0xA0, 0xE0, 0x60, // 103
    0xFE, 0xFE, 0x10, 0xF8, 0xF0, 0x20, 0x20, 0x00, 0x20, 0x20, // 104
    0xFA, 0xFA, 0x20, 0x20, // 105
    0x00, 0xFA, 0xFA, 0xC0, 0xE0, 0x60, // 106
    0xFE, 0xFE, 0x60, 0xF0, 0xD8, 0x08, 0x20, 0x20, 0x00, 0x00, 0x20, 0x20, // 107
    0xFE, 0xFE, 0x20, 0x20, // 108
    0xF8, 0xF8, 0x10, 0xF8, 0xF0, 0x18, 0xF8, 0xF0, 0x20, 0x20, 0x00, 0x20, 0x20, 0x00, 0x20, 0x20, // 109
    0xF8, 0xF8, 0x10, 0xF8, 0xF0, 0x20, 0x20, 0x00, 0x20, 0x20, // 110
    0xF0, 0xF8, 0x98, 0xF8, 0xF0, 0x00, 0x20, 0x20, 0x20, 0x00, // 111
    0xF8, 0xF8, 0x98, 0xF8, 0xF0, 0xE0, 0xE0, 0x20, 0x20, 0x00, // 112
    0xF0, 0xF8, 0x98, 0xF8, 0xF8, 0x00, 0x20, 0x20, 0xE0, 0xE0, // 113
    0xF8, 0xF8, 0x10, 0x18, 0x20, 0x20, 0x00, 0x00, // 114
    0xB0, 0x38, 0x68, 0xE8, 0xD0, 0x00, 0x20, 0x20, 0x20, 0x00, // 115
    0x18, 0xFC, 0xFE, 0x98, 0x00, 0x20, 0x20, 0x20, // 116
    0xF8, 0xF8, 0x80, 0xF8, 0xF8, 0x20, 0x20, 0x20, 0x20, 0x20, // 117
    0x08, 0x78, 0xF0, 0x80, 0xF0, 0x78, 0x08, 0x00, 0x00, 0x20, 0x20, 0x20, 0x00, 0x00, // 118
    0x18, 0xF8, 0xE0, 0xF8, 0x18, 0xF8, 0xE0, 0xF8, 0x18, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, // 119
    0x08, 0x98, 0xF0, 0x60, 0xF0, 0x98, 0x08, 0x20, 0x20, 0x00, 0x00, 0x00, 0x20, 0x20, // 120
    0x08, 0x78, 0xF0, 0x80, 0xF0, 0x78, 0x08, 0x80, 0x80, 0xE0, 0x60, 0x20, 0x00, 0x00, // 121
    0x98, 0xD8, 0xB8, 0x98, 0x20, 0x20, 0x20, 0x20, // 122
    0x60, 0xFC, 0xDE, 0x06, 0x00, 0x60, 0xE0, 0xC0, // 123
    0xFE, 0xE0, // 124
    0x06, 0xDE, 0xFC, 0x60, 0xC0, 0xE0, 0x60, 0x00, // 125
    0x30, 0x18, 0x18, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFC, 0x04, 0x04, 0x04, 0x04, 0xFC, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 // 127
    
};

#endif
