/*
	https://www.semesin.com
	TWI without buffer and interrupt
*/	


#include "twi_Semesin_Bufferless.h"
#ifdef __AVR__
#include "util/twi.h"

void twiInit(uint16_t frekuensi = 100000L)
{
  digitalWrite(SDA, 1);
  digitalWrite(SCL, 1);

	TWSR &= ~((1<<TWPS0) | (1<<TWPS1));
  TWBR = ((F_CPU / frekuensi) - 16) / 2;

  // TWCR = _BV(TWEN) | _BV(TWEA);
}


bool twiWrite(uint8_t I2CAddress, uint16_t memoryAddress, uint8_t data)
{
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = (uint8_t)(memoryAddress >> 8);
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
		
	TWDR = (uint8_t)memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	
	TWDR = data;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;

	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
}

bool twiWrite(uint8_t I2CAddress, uint8_t memoryAddress, uint8_t data)
{
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	
	TWDR = data;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;

	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
}

bool twiWrite(uint8_t I2CAddress, uint16_t memoryAddress, uint8_t *data)
{
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = (uint8_t)(memoryAddress >> 8);
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
		
	TWDR = (uint8_t)memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	
	uint8_t c;
	do 
	{
		c = *data++;
		TWDR = c;
		TWCR = (1<<TWINT) | (1<<TWEN);
		while (!(TWCR & (1<<TWINT)));
		if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
			goto error;
	}while(c);
	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
}

bool twiWrite(uint8_t I2CAddress, uint8_t memoryAddress, uint8_t *data)
{
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	
	uint8_t c;
	do 
	{
		c = *data++;
		TWDR = c;
		TWCR = (1<<TWINT) | (1<<TWEN);
		while (!(TWCR & (1<<TWINT)));
		if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
			goto error;
	}while(c);
	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
}

bool twiPool(uint8_t I2CAddress)
{
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;
	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
}

bool twiWrite(uint8_t I2CAddress, uint16_t memoryAddress, uint8_t *data, uint8_t length)
{
	// Serial.println(memoryAddress,HEX);
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = (uint8_t)(memoryAddress >> 8);
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
		
	TWDR = (uint8_t)memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;

	
	for(uint8_t i = 0;i<length;i++)
	{
		// Serial.println(*data);
		TWDR = *data++;
		TWCR = (1<<TWINT) | (1<<TWEN);
		while (!(TWCR & (1<<TWINT)));
		if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
			goto error;
	}
	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
}

bool twiWrite(uint8_t I2CAddress, uint8_t memoryAddress, uint8_t *data, uint8_t length)
{
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	
	for(uint8_t i = 0;i<length;i++)
	{
		TWDR = *data++;
		TWCR = (1<<TWINT) | (1<<TWEN);
		while (!(TWCR & (1<<TWINT)));
		if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	}
	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
}


uint8_t twiRead(uint8_t I2CAddress, uint16_t memoryAddress)
{
	uint8_t data;
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = (uint8_t)(memoryAddress >> 8);
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
		
	TWDR = (uint8_t)memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;

	
	// TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_REP_START)
		goto error;
		
	TWDR = I2CAddress<<1 | 0x01;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_SLA_ACK)
		goto error;

	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_DATA_NACK)
		goto error;
	
	data = TWDR;

	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return data;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return -1;
}

uint8_t twiRead(uint8_t I2CAddress, uint8_t memoryAddress)
{
	uint8_t data;
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	
	
	// TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_REP_START)
		goto error;
		
	TWDR = I2CAddress<<1 | 0x01;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_SLA_ACK)
		goto error;

	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_DATA_NACK)
		goto error;
	
	data = TWDR;

	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return data;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return -1;
}

bool twiRead(uint8_t I2CAddress, uint16_t memoryAddress, uint8_t *data)
{
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = (uint8_t)(memoryAddress >> 8);
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
		
	TWDR = (uint8_t)memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;

	
	// TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_REP_START)
		goto error;
		
	TWDR = I2CAddress<<1 | 0x01;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_SLA_ACK)
		goto error;

	uint8_t recv;
	do
	{
		TWCR = (1<<TWINT) | (1<<TWEN) | (1<<TWEA);
		while (!(TWCR & (1<<TWINT)));
		if ((TWSR & 0xF8) != TW_MR_DATA_ACK)
			goto error;
		
		recv = TWDR;
		// Serial.println(recv,HEX);
		*data++ = recv;
	}while(recv != 0);

	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_DATA_NACK)
		goto error;

	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
		// Serial.println("OK");
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	
	Serial.println((TWSR & 0xF8), HEX);
	return false;
}

bool twiRead(uint8_t I2CAddress, uint8_t memoryAddress, uint8_t *data)
{
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	
	// TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_REP_START)
		goto error;
		
	TWDR = I2CAddress<<1 | 0x01;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_SLA_ACK)
		goto error;

	uint8_t recv;
	do
	{
		TWCR = (1<<TWINT) | (1<<TWEN) | (1<<TWEA);
		while (!(TWCR & (1<<TWINT)));
		if ((TWSR & 0xF8) != TW_MR_DATA_ACK)
			goto error;
		
		recv = TWDR;
		*data++ = recv;
	}while(recv != 0);

	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
}

bool twiRead(uint8_t I2CAddress, uint16_t memoryAddress, uint8_t *data, uint8_t length)
{
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = (uint8_t)(memoryAddress >> 8);
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
		
	TWDR = (uint8_t)memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	
	// TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_REP_START)
		goto error;
		
	TWDR = I2CAddress<<1 | 0x01;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_SLA_ACK)
		goto error;

	uint8_t recv;
	for(uint8_t i=0;i<length-1;i++)
	{
		TWCR = (1<<TWINT) | (1<<TWEN) | (1<<TWEA);
		while (!(TWCR & (1<<TWINT)));
		if ((TWSR & 0xF8) != TW_MR_DATA_ACK)
			goto error;
		
		*data++ = TWDR;
	}

	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_DATA_NACK)
		goto error;
	
	*data++ = TWDR;

	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
}

bool twiRead(uint8_t I2CAddress, uint8_t memoryAddress, uint8_t *data, uint8_t length)
{
	
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_START)
		goto error;
		
	TWDR = I2CAddress<<1;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_SLA_ACK)
		goto error;

	TWDR = memoryAddress;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MT_DATA_ACK)
		goto error;
	
	// TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_REP_START)
		goto error;
		
	TWDR = I2CAddress<<1 | 0x01;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_SLA_ACK)
		goto error;

	uint8_t recv;
	for(uint8_t i=0;i<length-1;i++)
	{
		TWCR = (1<<TWINT) | (1<<TWEN) | (1<<TWEA);
		while (!(TWCR & (1<<TWINT)));
		if ((TWSR & 0xF8) != TW_MR_DATA_ACK)
		goto error;
		
		*data++ = TWDR;
	}
	
	TWCR = (1<<TWINT) | (1<<TWEN);
	while (!(TWCR & (1<<TWINT)));
	if ((TWSR & 0xF8) != TW_MR_DATA_NACK)
		goto error;
	
	*data++ = TWDR;

	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return true;
	
error:	
	TWCR = (1<<TWINT)|(1<<TWEN)| (1<<TWSTO);
	while (TWCR & (1<<TWSTO));
	return false;
	
}
#endif