#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef FIXED_BOLD10x15_H
#define FIXED_BOLD10x15_H

#define FIXED_BOLD10x15_WIDTH 10 
#define FIXED_BOLD10x15_HEIGHT 15 

static const uint8_t fixed_bold10x15[] PROGMEM = {
	0x0, 0x0, // size of zero indicates fixed width font, actual length is width * height
	0x0a, // width
	0x0f, // height
	0x20, // first char
	0x5F, // char count

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // *space*
	0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x19, 0x00, 0x00, 0x00, 0x00,  // !
	0x00, 0x00, 0x1e, 0x1e, 0x00, 0x00, 0x1e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // "
	0x00, 0x30, 0xfe, 0xfe, 0x30, 0x30, 0xfe, 0xfe, 0x30, 0x00, 0x00, 0x03, 0x1f, 0x1f, 0x03, 0x03, 0x1f, 0x1f, 0x03, 0x00,  // #
	0x00, 0x70, 0xf8, 0xd8, 0xfe, 0x98, 0x98, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x18, 0x7f, 0x19, 0x1f, 0x0f, 0x00, 0x00,  // $
	0x1c, 0xb6, 0xa2, 0xf6, 0xcc, 0x60, 0x60, 0x20, 0x30, 0x00, 0x01, 0x01, 0x00, 0x0e, 0x1b, 0x11, 0x1b, 0x0e, 0x00, 0x00,  // %
	0x00, 0x00, 0xdc, 0x7e, 0xe6, 0xc6, 0x86, 0x0c, 0x80, 0x80, 0x00, 0x07, 0x0f, 0x1c, 0x18, 0x19, 0x1f, 0x1e, 0x1f, 0x13,  // &
	0x00, 0x00, 0x00, 0x00, 0x1e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // '
	0x00, 0x00, 0x00, 0xe0, 0xfc, 0x1e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3f, 0x78, 0x40, 0x00, 0x00, 0x00,  // (
	0x00, 0x00, 0x02, 0x1e, 0xfc, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x78, 0x3f, 0x07, 0x00, 0x00, 0x00, 0x00,  // )
	0x00, 0x48, 0x78, 0x30, 0xfe, 0x30, 0x78, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,  // *
	0x00, 0x80, 0x80, 0x80, 0xf0, 0xf0, 0x80, 0x80, 0x80, 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x0f, 0x01, 0x01, 0x01, 0x00,  // +
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x7c, 0x3c, 0x00, 0x00, 0x00, 0x00,  // ,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00,  // -
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00,  // .
	0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0x3c, 0x0e, 0x02, 0x00, 0x00, 0x20, 0x38, 0x1e, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00,  // /
	0x00, 0xf0, 0xfc, 0x0e, 0xc6, 0xc6, 0x0e, 0xfc, 0xf8, 0x00, 0x00, 0x03, 0x0f, 0x1c, 0x18, 0x18, 0x1c, 0x0f, 0x07, 0x00,  // 0
	0x00, 0x00, 0x0c, 0x06, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x00,  // 1
	0x00, 0x0c, 0x06, 0x06, 0x06, 0x86, 0xc6, 0x7c, 0x38, 0x00, 0x00, 0x18, 0x1c, 0x1e, 0x1b, 0x19, 0x18, 0x18, 0x18, 0x00,  // 2
	0x00, 0x0c, 0x06, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x38, 0x00, 0x00, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x19, 0x0f, 0x0f, 0x00,  // 3
	0x00, 0x80, 0xc0, 0x70, 0x18, 0x0e, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1f, 0x1f, 0x03, 0x00,  // 4
	0x00, 0xfe, 0x7e, 0x66, 0x66, 0x66, 0xe6, 0xc6, 0x80, 0x00, 0x00, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x0f, 0x07, 0x00,  // 5
	0x00, 0xf0, 0xfc, 0xce, 0x66, 0x66, 0xe6, 0xcc, 0x80, 0x00, 0x00, 0x07, 0x0f, 0x1c, 0x18, 0x18, 0x1c, 0x0f, 0x07, 0x00,  // 6
	0x00, 0x06, 0x06, 0x06, 0x06, 0xe6, 0xfe, 0x3e, 0x0e, 0x00, 0x00, 0x00, 0x10, 0x1c, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00,  // 7
	0x00, 0x38, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x38, 0x00, 0x00, 0x0f, 0x0f, 0x18, 0x18, 0x18, 0x18, 0x0f, 0x0f, 0x00,  // 8
	0x00, 0x78, 0xfc, 0xce, 0x86, 0x86, 0xce, 0xfc, 0xf8, 0x00, 0x00, 0x00, 0x0c, 0x19, 0x19, 0x19, 0x1c, 0x0f, 0x03, 0x00,  // 9
	0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00,  // :
	0x00, 0x00, 0x00, 0x00, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x7c, 0x3c, 0x00, 0x00, 0x00, 0x00,  // ;
	0x00, 0x80, 0x80, 0xc0, 0x40, 0x60, 0x60, 0x20, 0x30, 0x00, 0x00, 0x01, 0x01, 0x03, 0x02, 0x06, 0x06, 0x04, 0x0c, 0x00,  // <
	0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,  // =
	0x00, 0x30, 0x20, 0x60, 0x60, 0x40, 0xc0, 0x80, 0x80, 0x00, 0x00, 0x0c, 0x04, 0x06, 0x06, 0x02, 0x03, 0x01, 0x01, 0x00,  // >
	0x00, 0x0c, 0x06, 0x86, 0xc6, 0x66, 0x7e, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00,  // ?
	0xe0, 0xf0, 0x38, 0x9c, 0xcc, 0xcc, 0xdc, 0xf8, 0xf0, 0x00, 0x07, 0x1f, 0x38, 0x73, 0x67, 0x66, 0x66, 0x77, 0x27, 0x00,  // @
	0x00, 0x00, 0xc0, 0xfc, 0x3e, 0x3e, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x18, 0x1f, 0x0f, 0x03, 0x03, 0x0f, 0x1f, 0x18, 0x00,  // A
	0x00, 0xfe, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x3c, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x0f, 0x00,  // B
	0x00, 0xf0, 0xfc, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x00, 0x00, 0x03, 0x0f, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x00,  // C
	0x00, 0xfe, 0xfe, 0x06, 0x06, 0x06, 0x0c, 0xfc, 0xf0, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x0c, 0x0f, 0x03, 0x00,  // D
	0x00, 0xfe, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,  // E
	0x00, 0xfe, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // F
	0x00, 0xf0, 0xfc, 0x0c, 0x06, 0x86, 0x86, 0x86, 0x8c, 0x00, 0x00, 0x03, 0x0f, 0x0c, 0x18, 0x19, 0x19, 0x1f, 0x0f, 0x00,  // G
	0x00, 0xfe, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0xfe, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00,  // H
	0x00, 0x00, 0x06, 0x06, 0xfe, 0xfe, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x00, 0x00,  // I
	0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0xfe, 0xfe, 0x00, 0x00, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0f, 0x0f, 0x00,  // J
	0x00, 0xfe, 0xfe, 0xe0, 0xf0, 0xfc, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x03, 0x0f, 0x1e, 0x18, 0x00,  // K
	0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,  // L
	0x00, 0xfe, 0xfe, 0x3e, 0xf0, 0xf0, 0x3e, 0xfe, 0xfe, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x01, 0x01, 0x00, 0x1f, 0x1f, 0x00,  // M
	0x00, 0xfe, 0xfe, 0x1e, 0xf0, 0xc0, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x03, 0x1e, 0x1f, 0x1f, 0x00,  // N
	0x00, 0xf0, 0xfc, 0x0e, 0x06, 0x06, 0x0e, 0xfc, 0xf0, 0x00, 0x00, 0x03, 0x0f, 0x1c, 0x18, 0x18, 0x1c, 0x0f, 0x03, 0x00,  // O
	0x00, 0xfe, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x7c, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // P
	0x00, 0xf0, 0xfc, 0x0e, 0x06, 0x06, 0x0e, 0xfc, 0xf0, 0x00, 0x00, 0x03, 0x0f, 0x1c, 0x18, 0x18, 0x3c, 0x6f, 0x07, 0x00,  // Q
	0x00, 0xfe, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x3c, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x01, 0x03, 0x1f, 0x1e, 0x10,  // R
	0x00, 0x38, 0x7c, 0xe6, 0xc6, 0xc6, 0xc6, 0x8c, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x19, 0x0f, 0x0f, 0x00,  // S
	0x00, 0x06, 0x06, 0x06, 0xfe, 0xfe, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00,  // T
	0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x07, 0x0f, 0x1c, 0x18, 0x18, 0x1c, 0x0f, 0x07, 0x00,  // U
	0x00, 0x06, 0xfe, 0xfc, 0x00, 0x00, 0xfc, 0xfe, 0x06, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00,  // V
	0x1e, 0xfe, 0xe0, 0x00, 0xf0, 0xf0, 0x00, 0xe0, 0xfe, 0x1e, 0x00, 0x1f, 0x1f, 0x1e, 0x01, 0x01, 0x1e, 0x1f, 0x1f, 0x00,  // W
	0x00, 0x02, 0x0e, 0x3e, 0xf8, 0xf8, 0x3e, 0x0e, 0x02, 0x00, 0x00, 0x10, 0x1c, 0x1f, 0x03, 0x03, 0x1f, 0x1c, 0x10, 0x00,  // X
	0x02, 0x0e, 0x3e, 0x78, 0xe0, 0xe0, 0x78, 0x3e, 0x0e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00,  // Y
	0x00, 0x06, 0x06, 0x86, 0xc6, 0xf6, 0x7e, 0x1e, 0x0e, 0x00, 0x00, 0x1c, 0x1e, 0x1f, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x00,  // Z
	0x00, 0x00, 0x00, 0xfe, 0xfe, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x40, 0x40, 0x00, 0x00, 0x00,  // [
	0x00, 0x02, 0x0e, 0x38, 0xe0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0e, 0x38, 0x20, 0x00,  // *backslash*
	0x00, 0x00, 0x02, 0x02, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00,  // ]
	0x10, 0x18, 0x1c, 0x0e, 0x06, 0x0e, 0x1c, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ^
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,  // _
	0x00, 0x00, 0x01, 0x03, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // `
	0x00, 0x00, 0x60, 0x30, 0xb0, 0xb0, 0xb0, 0xf0, 0xe0, 0x00, 0x00, 0x0e, 0x1f, 0x1b, 0x19, 0x19, 0x0d, 0x1f, 0x1f, 0x00,  // a
	0x00, 0xfe, 0xfe, 0x60, 0x30, 0x30, 0x70, 0xe0, 0xc0, 0x00, 0x00, 0x1f, 0x1f, 0x0c, 0x18, 0x18, 0x1c, 0x0f, 0x07, 0x00,  // b
	0x00, 0xc0, 0xe0, 0x70, 0x30, 0x30, 0x30, 0x30, 0x60, 0x00, 0x00, 0x07, 0x0f, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x00,  // c
	0x00, 0xc0, 0xe0, 0x70, 0x30, 0x30, 0x60, 0xfe, 0xfe, 0x00, 0x00, 0x07, 0x0f, 0x1c, 0x18, 0x18, 0x0c, 0x1f, 0x1f, 0x00,  // d
	0x00, 0xc0, 0xe0, 0xb0, 0xb0, 0xb0, 0xb0, 0xe0, 0xc0, 0x00, 0x00, 0x07, 0x0f, 0x1d, 0x19, 0x19, 0x19, 0x19, 0x0d, 0x00,  // e
	0x00, 0x30, 0x30, 0xfc, 0xfe, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,  // f
	0x00, 0xc0, 0xe0, 0x70, 0x30, 0x30, 0x60, 0xf0, 0xf0, 0x00, 0x00, 0x03, 0x37, 0x6e, 0x6c, 0x6c, 0x66, 0x7f, 0x3f, 0x00,  // g
	0x00, 0xfe, 0xfe, 0x60, 0x30, 0x30, 0x30, 0xf0, 0xe0, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00,  // h
	0x00, 0x00, 0x30, 0x30, 0xf7, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x00,  // i
	0x00, 0x00, 0x30, 0x30, 0xf7, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x7f, 0x3f, 0x00, 0x00, 0x00, 0x00,  // j
	0x00, 0xfe, 0xfe, 0x80, 0xe0, 0x70, 0x30, 0x10, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x01, 0x03, 0x07, 0x1e, 0x18, 0x10, 0x00,  // k
	0x00, 0x06, 0x06, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x18, 0x18, 0x18, 0x00, 0x00,  // l
	0x00, 0xf0, 0xf0, 0x30, 0xf0, 0xe0, 0x30, 0xf0, 0xe0, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00, 0x1f, 0x1f, 0x00,  // m
	0x00, 0xf0, 0xf0, 0x60, 0x30, 0x30, 0x30, 0xf0, 0xe0, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00,  // n
	0x00, 0xc0, 0xe0, 0x70, 0x30, 0x30, 0x70, 0xe0, 0xc0, 0x00, 0x00, 0x07, 0x0f, 0x1c, 0x18, 0x18, 0x1c, 0x0f, 0x07, 0x00,  // o
	0x00, 0xf0, 0xf0, 0x60, 0x30, 0x30, 0x70, 0xe0, 0xc0, 0x00, 0x00, 0x7f, 0x7f, 0x06, 0x0c, 0x0c, 0x0e, 0x07, 0x03, 0x00,  // p
	0x00, 0xc0, 0xe0, 0x70, 0x30, 0x30, 0x60, 0xf0, 0xf0, 0x00, 0x00, 0x03, 0x07, 0x0e, 0x0c, 0x0c, 0x06, 0x7f, 0x7f, 0x00,  // q
	0x00, 0x00, 0xf0, 0xf0, 0x60, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // r
	0x00, 0xe0, 0xf0, 0xb0, 0xb0, 0xb0, 0xb0, 0x30, 0x60, 0x00, 0x00, 0x0c, 0x19, 0x19, 0x19, 0x19, 0x1b, 0x1f, 0x0e, 0x00,  // s
	0x00, 0x30, 0x30, 0xfc, 0xfc, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x18, 0x18, 0x18, 0x00, 0x00,  // t
	0x00, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00, 0x0f, 0x1f, 0x18, 0x18, 0x18, 0x0c, 0x1f, 0x1f, 0x00,  // u
	0x00, 0x30, 0xf0, 0xe0, 0x00, 0x00, 0xe0, 0xf0, 0x30, 0x00, 0x00, 0x00, 0x01, 0x0f, 0x1e, 0x1e, 0x0f, 0x01, 0x00, 0x00,  // v
	0x70, 0xf0, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0xf0, 0x70, 0x00, 0x07, 0x1f, 0x1e, 0x03, 0x03, 0x1e, 0x1f, 0x07, 0x00,  // w
	0x00, 0x10, 0x30, 0xf0, 0xc0, 0xc0, 0xf0, 0x30, 0x10, 0x00, 0x00, 0x10, 0x18, 0x1e, 0x07, 0x07, 0x1e, 0x18, 0x10, 0x00,  // x
	0x00, 0x10, 0xf0, 0xf0, 0x80, 0x00, 0xf0, 0xf0, 0x30, 0x00, 0x00, 0x00, 0x60, 0x63, 0x7f, 0x1f, 0x0f, 0x01, 0x00, 0x00,  // y
	0x00, 0x30, 0x30, 0x30, 0x30, 0xb0, 0xf0, 0x70, 0x30, 0x00, 0x00, 0x18, 0x1c, 0x1e, 0x1b, 0x19, 0x18, 0x18, 0x18, 0x00,  // z
	0x00, 0x00, 0x00, 0x00, 0xfc, 0xfe, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x3e, 0x7e, 0x40, 0x40, 0x00, 0x00,  // {
	0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00,  // |
	0x00, 0x00, 0x02, 0x02, 0xfe, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x7e, 0x3e, 0x01, 0x01, 0x00, 0x00,  // }
	0x00, 0x80, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0xc0, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00,  // ~
};
#endif
