#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef _Callibri15_H
#define _Callibri15_H

#define Callibri15_WIDTH 10
#define Callibri15_HEIGHT 15

static const uint8_t Callibri15[] PROGMEM = {
    0x20, 0x55, // size
    0x0A, // width
    0x0F, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x02, 0x01, 0x04, 0x08, 0x06, 0x0A, 0x09, 0x01, 0x03, 0x03, 
    0x05, 0x07, 0x02, 0x03, 0x01, 0x06, 0x06, 0x05, 0x06, 0x06, 
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x02, 0x06, 0x07, 
    0x06, 0x05, 0x0C, 0x09, 0x07, 0x08, 0x08, 0x06, 0x05, 0x08, 
    0x08, 0x01, 0x04, 0x06, 0x06, 0x0B, 0x08, 0x09, 0x06, 0x0A, 
    0x07, 0x05, 0x07, 0x08, 0x09, 0x0B, 0x08, 0x07, 0x07, 0x03, 
    0x06, 0x03, 0x07, 0x08, 0x03, 0x06, 0x06, 0x05, 0x06, 0x06, 
    0x04, 0x07, 0x06, 0x01, 0x02, 0x05, 0x01, 0x09, 0x06, 0x06, 
    0x06, 0x06, 0x04, 0x05, 0x04, 0x06, 0x05, 0x09, 0x05, 0x05, 
    0x04, 0x04, 0x01, 0x04, 0x07, 0x08, 
    
    // font data
    0x00, 0x00, 0x00, 0x00, // 0x20 <space>
    0xFE, 0x1A, // 33
    0x1E, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, // 34
    0x20, 0xA0, 0x7C, 0x20, 0x20, 0xA0, 0x7C, 0x20, 0x02, 0x1E, 0x02, 0x02, 0x02, 0x1E, 0x02, 0x02, // 35
    0x38, 0x44, 0x44, 0x87, 0x84, 0x08, 0x08, 0x10, 0x70, 0x10, 0x10, 0x0E, // 36
    0x38, 0x44, 0x44, 0x38, 0x80, 0x60, 0x10, 0x8C, 0x80, 0x00, 0x00, 0x00, 0x18, 0x04, 0x02, 0x00, 0x0E, 0x10, 0x10, 0x0E, // 37
    0x80, 0x5C, 0x22, 0x62, 0x92, 0x0C, 0x00, 0xC0, 0x00, 0x0E, 0x10, 0x10, 0x10, 0x10, 0x0A, 0x04, 0x0A, 0x10, // 38
    0x1E, 0x00, // 39
    0xF0, 0x0C, 0x02, 0x1E, 0x60, 0x80, // 40
    0x02, 0x0C, 0xF0, 0x80, 0x60, 0x1E, // 41
    0x24, 0x18, 0x7E, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x80, 0x80, 0x80, 0xF0, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x40, 0x38, // 44
    0x00, 0x00, 0x00, 0x02, 0x02, 0x02, // 45
    0x00, 0x18, // 46
    0x00, 0x00, 0x80, 0x60, 0x18, 0x06, 0x60, 0x18, 0x06, 0x00, 0x00, 0x00, // 47
    0xF8, 0x04, 0x04, 0x04, 0x04, 0xF8, 0x0E, 0x10, 0x10, 0x10, 0x10, 0x0E, // 48
    0x10, 0x08, 0xFC, 0x00, 0x00, 0x10, 0x10, 0x1E, 0x10, 0x10, // 49
    0x08, 0x04, 0x04, 0x04, 0xC4, 0x38, 0x10, 0x18, 0x14, 0x12, 0x10, 0x10, // 50
    0x08, 0x44, 0x44, 0x44, 0x44, 0xB8, 0x08, 0x10, 0x10, 0x10, 0x10, 0x0E, // 51
    0x00, 0xC0, 0x30, 0x0C, 0xFC, 0x00, 0x06, 0x04, 0x04, 0x04, 0x1E, 0x04, // 52
    0x00, 0x7C, 0x44, 0x44, 0x44, 0x84, 0x08, 0x10, 0x10, 0x10, 0x10, 0x0E, // 53
    0xF0, 0x88, 0x44, 0x44, 0x44, 0x84, 0x0E, 0x10, 0x10, 0x10, 0x10, 0x0E, // 54
    0x04, 0x04, 0x04, 0xC4, 0x34, 0x0C, 0x00, 0x10, 0x0C, 0x02, 0x00, 0x00, // 55
    0xB8, 0x44, 0x44, 0x44, 0x44, 0xB8, 0x0E, 0x10, 0x10, 0x10, 0x10, 0x0E, // 56
    0x78, 0x84, 0x84, 0x84, 0x44, 0xF8, 0x10, 0x10, 0x10, 0x10, 0x08, 0x06, // 57
    0x60, 0x18, // 58
    0x00, 0x60, 0x40, 0x38, // 59
    0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x00, 0x02, 0x02, 0x04, 0x04, 0x08, // 60
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, // 61
    0x10, 0x20, 0x20, 0x40, 0x40, 0x80, 0x08, 0x04, 0x04, 0x02, 0x02, 0x00, // 62
    0x04, 0x02, 0xC2, 0x42, 0x3C, 0x00, 0x00, 0x1A, 0x00, 0x00, // 63
    0xC0, 0x30, 0x08, 0x88, 0x44, 0x24, 0x24, 0x44, 0xE4, 0x04, 0x08, 0xF0, 0x0E, 0x30, 0x20, 0x46, 0x48, 0x48, 0x44, 0x46, 0x48, 0x08, 0x04, 0x02, // 64
    0x00, 0x00, 0xC0, 0x30, 0x0C, 0x30, 0xC0, 0x00, 0x00, 0x18, 0x06, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x18, // 65
    0xFC, 0x44, 0x44, 0x44, 0x44, 0xB8, 0x00, 0x1E, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0E, // 66
    0xF0, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x06, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, // 67
    0xFC, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0xF0, 0x1E, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x06, // 68
    0xFC, 0x44, 0x44, 0x44, 0x44, 0x04, 0x1E, 0x10, 0x10, 0x10, 0x10, 0x10, // 69
    0xFC, 0x44, 0x44, 0x44, 0x44, 0x1E, 0x00, 0x00, 0x00, 0x00, // 70
    0xF0, 0x08, 0x04, 0x04, 0x84, 0x84, 0x84, 0x88, 0x06, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0E, // 71
    0xFC, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xFC, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, // 72
    0xFC, 0x1E, // 73
    0x00, 0x00, 0x00, 0xFC, 0x10, 0x10, 0x10, 0x0E, // 74
    0xFC, 0x40, 0xA0, 0x10, 0x08, 0x04, 0x1E, 0x00, 0x00, 0x06, 0x08, 0x10, // 75
    0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x10, 0x10, 0x10, 0x10, 0x10, // 76
    0xFC, 0x0C, 0x30, 0xC0, 0x00, 0x00, 0x00, 0xC0, 0x30, 0x0C, 0xFC, 0x1E, 0x00, 0x00, 0x00, 0x06, 0x18, 0x06, 0x00, 0x00, 0x00, 0x1E, // 77
    0xFC, 0x04, 0x18, 0x60, 0x80, 0x00, 0x00, 0xFC, 0x1E, 0x00, 0x00, 0x00, 0x02, 0x0C, 0x10, 0x1E, // 78
    0xF0, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0xF0, 0x06, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x06, // 79
    0xFC, 0x84, 0x84, 0x84, 0x84, 0x78, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
    0xF0, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0xF0, 0x00, 0x06, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x26, 0x20, // 81
    0xFC, 0x84, 0x84, 0x84, 0x84, 0x78, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x02, 0x0C, 0x10, // 82
    0x38, 0x44, 0x44, 0x84, 0x08, 0x08, 0x10, 0x10, 0x10, 0x0E, // 83
    0x04, 0x04, 0x04, 0xFC, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, // 84
    0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x06, 0x08, 0x10, 0x10, 0x10, 0x10, 0x08, 0x06, // 85
    0x0C, 0x30, 0xC0, 0x00, 0x00, 0x00, 0xC0, 0x30, 0x0C, 0x00, 0x00, 0x00, 0x06, 0x18, 0x06, 0x00, 0x00, 0x00, // 86
    0x1C, 0xE0, 0x00, 0x00, 0xE0, 0x1C, 0xE0, 0x00, 0x00, 0xE0, 0x1C, 0x00, 0x02, 0x1C, 0x06, 0x00, 0x00, 0x00, 0x06, 0x1C, 0x02, 0x00, // 87
    0x04, 0x08, 0x30, 0xC0, 0xC0, 0x30, 0x08, 0x04, 0x10, 0x08, 0x06, 0x00, 0x00, 0x06, 0x08, 0x10, // 88
    0x04, 0x18, 0x60, 0x80, 0x60, 0x18, 0x04, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, // 89
    0x04, 0x04, 0x04, 0xC4, 0x24, 0x14, 0x0C, 0x18, 0x14, 0x12, 0x10, 0x10, 0x10, 0x10, // 90
    0xFE, 0x02, 0x02, 0xFE, 0x80, 0x80, // 91
    0x06, 0x18, 0x60, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, // 92
    0x02, 0x02, 0xFE, 0x80, 0x80, 0xFE, // 93
    0x80, 0x60, 0x18, 0x04, 0x18, 0x60, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, // 95
    0x02, 0x04, 0x08, 0x00, 0x00, 0x00, // 96
    0x40, 0x20, 0x20, 0x20, 0x20, 0xC0, 0x0C, 0x12, 0x12, 0x12, 0x0A, 0x1E, // 97
    0xFE, 0x40, 0x20, 0x20, 0x20, 0xC0, 0x1E, 0x08, 0x10, 0x10, 0x10, 0x0E, // 98
    0xC0, 0x20, 0x20, 0x20, 0x40, 0x0E, 0x10, 0x10, 0x10, 0x08, // 99
    0xC0, 0x20, 0x20, 0x20, 0x40, 0xFE, 0x0E, 0x10, 0x10, 0x10, 0x08, 0x1E, // 100
    0xC0, 0x20, 0x20, 0x20, 0x20, 0xC0, 0x0E, 0x12, 0x12, 0x12, 0x12, 0x12, // 101
    0x20, 0xFC, 0x22, 0x22, 0x00, 0x1E, 0x00, 0x00, // 102
    0xC0, 0x20, 0x20, 0x20, 0x20, 0xE0, 0x20, 0x6A, 0x94, 0x94, 0x94, 0x94, 0x92, 0x60, // 103
    0xFE, 0x40, 0x20, 0x20, 0x20, 0xC0, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x1E, // 104
    0xE8, 0x1E, // 105
    0x00, 0xE8, 0x80, 0x7E, // 106
    0xFE, 0x00, 0x80, 0x40, 0x20, 0x1E, 0x02, 0x04, 0x08, 0x10, // 107
    0xFE, 0x1E, // 108
    0xE0, 0x40, 0x20, 0x20, 0xC0, 0x40, 0x20, 0x20, 0xC0, 0x1E, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x1E, // 109
    0xE0, 0x40, 0x20, 0x20, 0x20, 0xC0, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x1E, // 110
    0xC0, 0x20, 0x20, 0x20, 0x20, 0xC0, 0x0E, 0x10, 0x10, 0x10, 0x10, 0x0E, // 111
    0xE0, 0x40, 0x20, 0x20, 0x20, 0xC0, 0xFE, 0x08, 0x10, 0x10, 0x10, 0x0E, // 112
    0xC0, 0x20, 0x20, 0x20, 0x40, 0xE0, 0x0E, 0x10, 0x10, 0x10, 0x08, 0xFE, // 113
    0xE0, 0x40, 0x20, 0x20, 0x1E, 0x00, 0x00, 0x00, // 114
    0xC0, 0x20, 0x20, 0x20, 0x20, 0x10, 0x12, 0x12, 0x12, 0x0C, // 115
    0x20, 0xF8, 0x20, 0x20, 0x00, 0x0E, 0x10, 0x10, // 116
    0xE0, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x0E, 0x10, 0x10, 0x10, 0x08, 0x1E, // 117
    0x60, 0x80, 0x00, 0x80, 0x60, 0x00, 0x06, 0x18, 0x06, 0x00, // 118
    0x60, 0x80, 0x00, 0x80, 0x60, 0x80, 0x00, 0x80, 0x60, 0x00, 0x06, 0x18, 0x06, 0x00, 0x06, 0x18, 0x06, 0x00, // 119
    0x20, 0xC0, 0x00, 0xC0, 0x20, 0x10, 0x0C, 0x02, 0x0C, 0x10, // 120
    0x60, 0x80, 0x00, 0x80, 0x60, 0x00, 0xC6, 0x38, 0x06, 0x00, // 121
    0x20, 0x20, 0xA0, 0x60, 0x18, 0x16, 0x10, 0x10, // 122
    0x80, 0x7C, 0x02, 0x02, 0x00, 0x7E, 0x80, 0x80, // 123
    0xFE, 0xFE, // 124
    0x02, 0x02, 0x7C, 0x80, 0x80, 0x80, 0x7E, 0x00, // 125
    0x30, 0x08, 0x08, 0x10, 0x20, 0x20, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFC, 0x04, 0x14, 0x94, 0x94, 0x64, 0x04, 0xFC, 0x1E, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x1E // 127
    
};

#endif
