/*
   http://www.semesin.com/project
*/

#ifndef DMD_SEMESIN_H
#define DMD_SEMESIN_H

#include "SPI.h"

#define breakOnSerial   0
#define pakaiSerialPort 0

// #define PANEL_WIDTH    32
// #define PANEL_HEIGHT 16
// const unsigned int PANEL_WIDTH = 32;
// const unsigned int PANEL_HEIGHT = 16;

class DMD_TextBox;
class DMDFrame;

struct HeaderGambar {
  uint8_t width;
  uint8_t height;
};

enum SumberInformasi
{
  sumberRAM,
  sumberFlash,
  sumberI2CEEPROM0x57,
  sumberFFS,
};

enum warna
{
	// R G B
	hitam,
	merah,
	hijau,
	kuning,
	biru,
	magenta,
	cyan,
	putih,
	
};
enum modeEfek
{
  nonAktif,
  inX,
  inY,
  outX,
  outY,
  XPlus,
  XMinus,
  YPlus,
  YMinus,
  inXPlus,
  inXMinus,
  inYPlus,
  inYMinus,
  outXPlus,
  outXMinus,
  outYPlus,
  outYMinus,

};
struct EfekMarque
{
  uint8_t mode;
  uint8_t init;
  uint8_t sumber;
  uint8_t *font;
#ifdef __AVR__
  uint16_t alamat;
#else  
  uint32_t alamat;
#endif
  uint8_t kiri;
  uint8_t atas;
  uint8_t lebar;
  uint8_t tinggi;
  uint8_t step;
  uint8_t skip;
  uint8_t clear;
  char _data;
  int16_t _posisi;
  int16_t _panjang;
};

struct EfekMarqueIn
{
  uint8_t mode;
  uint8_t kiri;
  uint8_t atas;
  uint8_t lebar;
  uint8_t tinggi;
  uint8_t step;
  int16_t posisiInit;
};

struct EfekMarqueClear
{
  uint8_t mode;
  bool mulai;
  uint8_t kiri;
  uint8_t atas;
  uint8_t lebar;
  uint8_t tinggi;
  uint8_t step;
  uint8_t _posisiInit;
};

struct EfekWipe
{
  uint8_t mode;
  uint8_t kiri;
  uint8_t atas;
  uint8_t lebar;
  uint8_t tinggi;
  uint8_t posisi;
  uint8_t step;
  uint8_t mulai;
  uint8_t selesai;
};

struct EfekTulis
{
  uint8_t aktif;
  uint8_t sumber;
#ifdef __AVR__
  uint16_t alamat;
#else  
  uint32_t alamat;
#endif
  uint8_t index;
  uint8_t efekTulis;
  uint8_t efekTulisDataIndex;
  int8_t posisiX;
  int8_t posisiY;
};

struct EfekWipeCenter
{
  uint8_t mode;
  uint8_t tengah;
  uint8_t posisi;
  uint8_t berhenti;
  uint8_t step1;
  uint8_t step2;
  uint8_t kiri;
  uint8_t atas;
  uint8_t lebar;
  uint8_t tinggi;
};

// Clamp a value between two limits
template<typename T> static inline void clamp(T &value, T lower, T upper) {
  if (value < lower)
    value = lower;
  else if (value > upper)
    value = upper;
}

// Swap A & B "in place" (well, with a temp variable!)
template<typename T> static inline void swap(T &a, T &b)
{
  T tmp(a); a = b; b = tmp;
}

// Check a<=b, and swap them otherwise
template<typename T> static inline void ensureOrder(T &a, T &b)
{
  if (b < a) swap(a, b);
}

extern const uint8_t DMD_Pixel_Lut[]; /* Lookup table for the DMD pixel locations */

enum DMDTestPattern {
  PATTERN_ALT_0,
  PATTERN_ALT_1,
  PATTERN_STRIPE_0,
  PATTERN_STRIPE_1
};

//Pixel/graphics writing modes
enum DMDGraphicsMode {
  GRAPHICS_OFF, // unconditionally off (pixel turns off)
  GRAPHICS_ON, //unconditionally on (pixel turns on, the usual default for drawing)
  GRAPHICS_INVERSE, // on if was going to set to off
  GRAPHICS_OR, // add to pixels already on
  GRAPHICS_NOR, // subtract from pixels already on, don't turn any new ones on
  GRAPHICS_XOR, // swap on/off state of pixels
  GRAPHICS_NOOP // No-Op, ie don't actually change anything
};

// Return the inverse/"clear" version of the given mode
// ie for normal pixel-on modes, the "clear" is to turn off.
// for inverse mode, it's to turn on.
// for all other modes, this is kind of meaningless so we return a no-op
inline static DMDGraphicsMode inverseMode(DMDGraphicsMode mode) {
  switch (mode) {
    case GRAPHICS_ON:
      return GRAPHICS_OFF;
    case GRAPHICS_INVERSE:
      return GRAPHICS_ON;
    default:
      return GRAPHICS_NOOP;
  }
};

// Six byte header at beginning of FontCreator font structure, stored in PROGMEM
struct FontHeader {
  uint16_t size;
  uint8_t fixedWidth;
  uint8_t height;
  uint8_t firstChar;
  uint8_t charCount;
};

/* DMDFrame is a class encapsulating a framebuffer for the DMD, and all the graphical
   operations associated with it.

   This allows you to implement double buffered/frame flipping, etc.
*/
class DMDFrame
{

    friend class DMD_TextBox;
  public:

    FontHeader fontHeader;

    DMDFrame(byte Width_in_panels, byte Height_in_panels, byte PixelWidthPerPanel, byte PixelHeightPerPanel, bool WaitInterruptOver = true);
    DMDFrame(uint16_t PixelsWide, byte PixelsHigh, bool WaitInterruptOver = true);
    // DMDFrame(const DMDFrame &source);
    // virtual ~DMDFrame();

    void setPeriod(long microseconds);
    // Set a single LED on or off
    void setPixel(int x, int y, DMDGraphicsMode mode = GRAPHICS_ON);

    // Get status of a single LED
    bool getPixel(int x, int y);

    // Move a region of pixels from one area to another
    void movePixels(unsigned int from_x, unsigned int from_y,
                    unsigned int to_x, unsigned int to_y,
                    unsigned int width, unsigned int height);

    void moveFrame(int x, int y);
	void moveFrame(uint8_t left, uint8_t top, uint8_t lebar, uint8_t tinggi, int offsetX, int offsetY);
    void copySubFrame(DMDFrame *from, uint8_t left, uint8_t top, uint8_t width, uint8_t height, int offsetX=0, int offsetY=0);


    // Extract a sub-region of the frame as a new frame
    DMDFrame subFrame(unsigned int left, unsigned int top, unsigned int width, unsigned int height);

    // Copy the contents of another frame back into this one at the given location
    void copyFrame(DMDFrame &from, unsigned int left, unsigned int top);

    // Fill the screen on or off
	void fillScreen(byte warnaIsi);
    inline void clearScreen() 
	{
		fillScreen(0);
    };

    // the buffer passed must be large enough for all pixels plus a line ending
    void debugPixelLine(unsigned int y, char *buf);

    // Drawing primitives
    void drawLine(int x1, int y1, int x2, int y2, DMDGraphicsMode mode = GRAPHICS_ON);
    void drawCircle(unsigned int xCenter, unsigned int yCenter, int radius, DMDGraphicsMode mode = GRAPHICS_ON);
    void drawFilledCircle(unsigned int xCenter, unsigned int yCenter, int radius, DMDGraphicsMode mode = GRAPHICS_ON);
    void drawBox(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, DMDGraphicsMode mode = GRAPHICS_ON);
    void drawFilledBox(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, DMDGraphicsMode mode = GRAPHICS_ON);
    void drawTestPattern(DMDTestPattern pattern);
    void drawImage(int w, int h, byte *image);

    // Text primitives
    void selectFont(const uint8_t* font);
    const inline uint8_t *getFont(void) {
      return font;
    }
    int drawChar(const int x, const int y, const char letter, DMDGraphicsMode mode = GRAPHICS_ON, const uint8_t *font = NULL);
    int drawCharWidth(const int x, const int y, const char letter, int widthLimit, DMDGraphicsMode mode = GRAPHICS_ON, const uint8_t *font = NULL);

    void drawString(int x, int y, const char *bChars, DMDGraphicsMode mode = GRAPHICS_ON, const uint8_t *font = NULL);
    void drawString(int x, int y, const String &str, DMDGraphicsMode mode = GRAPHICS_ON, const uint8_t *font = NULL);
#if defined(__AVR__) || defined(ESP8266)
    void drawString_P(int x, int y, const char *flashStr, DMDGraphicsMode mode = GRAPHICS_ON, const uint8_t *font = NULL);
    inline void drawString(int x, int y, const __FlashStringHelper *flashStr, DMDGraphicsMode mode = GRAPHICS_ON, const uint8_t *font = NULL) {
      return drawString_P(x, y, (const char*)flashStr, mode, font);
    }
#endif

    //Find the width of a character
    int charWidth(const char letter, const uint8_t *font = NULL);

    //Find the width of a string (width of all characters plus 1 pixel "kerning" between each character)
#if defined(__AVR__) || defined(ESP8266)
    unsigned int stringWidth_P(const char *flashStr, const uint8_t *font = NULL);
    inline unsigned int stringWidth(const __FlashStringHelper *flashStr, const uint8_t *font = NULL) {
      return stringWidth_P((const char*)flashStr, font);
    }
#endif
    unsigned int stringWidth(const char *bChars, const uint8_t *font = NULL);
    unsigned int stringWidth(const String &str, const uint8_t *font = NULL);

    // Scrolling & marquee support
    void scrollY(int scrollBy);
    void scrollX(int scrollBy);
    void marqueeScrollX(int scrollBy);
    void marqueeScrollY(int scrollBy);

    void wipeXInMinus(EfekWipe *efekMarque, DMDFrame *frame);
    void wipeXInPlus(EfekWipe *efekMarque, DMDFrame *frame);
    void wipeYInMinus(EfekWipe *efekMarque, DMDFrame *frame);
    void wipeYInPlus(EfekWipe *efekMarque, DMDFrame *frame);

    void wipeXOutMinus(EfekWipe *efekMarque);
    void wipeXOutPlus(EfekWipe *efekMarque);
    void wipeYOutMinus(EfekWipe *efekMarque);
    void wipeYOutPlus(EfekWipe *efekMarque);

    void marqueeXMinus(EfekMarque *efekMarque);
    void marqueeXPlus(EfekMarque *efekMarque);
    void marqueeYMinus(EfekMarque *efekMarque);
    void marqueeYPlus(EfekMarque *efekMarque);

    void marqueeXInMinus(EfekMarqueIn *efekMarqueIn, DMDFrame *frame);
    void marqueeXInPlus(EfekMarqueIn *efekMarqueIn, DMDFrame *frame);
    void marqueeYInMinus(EfekMarqueIn *efekMarqueIn, DMDFrame *frame);
    void marqueeYInPlus(EfekMarqueIn *efekMarqueIn, DMDFrame *frame);

    void marqueeClearXMinus(EfekMarqueClear *efekMarqueClear);
    void marqueeClearXPlus(EfekMarqueClear *efekMarqueClear);
    void marqueeClearYMinus(EfekMarqueClear *efekMarqueClear);
    void marqueeClearYPlus(EfekMarqueClear *efekMarqueClear);

    void wipeXOutCenter(EfekWipeCenter *efekWipeCenter);
    void wipeXInCenter(EfekWipeCenter *efekWipeCenter, DMDFrame *frame);

    int drawImage(const int x, const int y, const uint8_t image, DMDGraphicsMode mode = GRAPHICS_ON);

    void swapBuffers(DMDFrame &other);

    uint16_t width; // in pixels
    const byte height; // in pixels
	bool inverse;
	uint8_t warna;
	uint8_t latar;
    bool waitInterruptOver;

    uint8_t *font;
    volatile bool scanningFlag;

    void setInverse(bool inverseMode)
	{
		inverse = inverseMode;
	}
    virtual void scanDisplay();
	byte widthBytesToShow;

  protected:

    const byte width_in_panels;
    const byte height_in_panels;
    const byte pixelWidthPerPanel;
    const byte pixelHeightPerPanel;
    byte row_width_bytes; // width in bitmap, bit-per-pixel rounded up to nearest byte
    byte bitmapRowWidthBytes;

#ifdef jumlahKolomPanel
    // volatile uint8_t bitmap[(((jumlahKolomPanel * PANEL_WIDTH) + 7)/8) * (jumlahBarisPanel * PANEL_HEIGHT)];
    volatile uint8_t *bitmap;
#else
    volatile uint8_t *bitmap;
#endif

    // byte height_in_panels; // in panels

    inline uint16_t bitmap_bytes() {
      // total bytes in the bitmap
      return row_width_bytes * height;
    }
    inline uint8_t unified_width_bytes() {
      // controller sees all panels as end-to-end, so bitmap arranges it that way
      return row_width_bytes * height_in_panels;
    }
    inline int pixelToBitmapIndex(unsigned int x, unsigned int y) {
      if (y >= pixelHeightPerPanel)
      {
        x += ((y / pixelHeightPerPanel) * width);
        y = y % pixelHeightPerPanel;
      }
      int res = (x / 8) + (y * bitmapRowWidthBytes);
      // int res = (x * 8) + y;

      return res;
    }
    inline uint8_t pixelToBitmask(unsigned int x) {
      int res = pgm_read_byte(DMD_Pixel_Lut + (x & 0x07));
      return res;
    }

    template<typename T> inline void clamp_xy(T &x, T&y) {
      clamp(x, (T)0, (T)width - 1);
      clamp(y, (T)0, (T)width - 1);
    }
};


class HUB12 : public DMDFrame
{
  protected:
    HUB12(byte panelsWide, byte panelsHigh, byte pin_noe, byte pin_a, byte pin_b, byte pin_sck);

    virtual void writeSPIData(volatile uint8_t *rows[4], uint8_t rowsize) = 0;
  public:
    /* Refresh the display by manually scanning out current array of
       pixels. Call often, or use begin()/end() to automatically scan
       the display (see below.)
    */

    /* Automatically start/stop scanning of the display output at
       flicker-free speed.  Setting this option will use Timer1 on
       AVR-based Arduinos or Timer7 on Arduino Due.
    */
    void scanDisplay();
    void begin();
    void end();

    /* Start display, but use manual scanning */
    virtual void beginNoTimer();

    inline void setBrightness(byte level)
    {
      brightness = level;
    };


    // DMDFrame backGround;

  protected:
    volatile byte scan_row;
    byte pin_noe;
    byte pin_a;
    byte pin_b;
    byte pin_sck;

    bool default_pins; // shortcut for default pin behaviour, can use macro writes
    uint8_t brightness;

};

class SPIDMD : public HUB12
{
  public:
    /* Create a single DMD display */
    SPIDMD();
    /* Create a DMD display using the default pinout, panelsWide x panelsHigh panels in size */
    SPIDMD(byte panelsWide, byte panelsHigh);
    /* Create a DMD display using a custom pinout for all the non-SPI pins (SPI pins set by hardware) */
    SPIDMD(byte panelsWide, byte panelsHigh, byte pin_noe, byte pin_a, byte pin_b, byte pin_sck);

    void beginNoTimer();

  protected:
    void writeSPIData(volatile uint8_t *rows[4], uint8_t rowsize);
};


class DMD_TextBox : public Print {
  public:
    DMD_TextBox(DMDFrame &dmd, int left = 0, int top = 0, int width = 0, int height = 0);
    virtual size_t write(uint8_t);
    void clear();
    void reset();
    void invertDisplay() {
      inverted = !inverted;
    }

    void scrollY(int scrollBy);
    void scrollX(int scrollBy);
  private:
    DMDFrame &dmd;
    bool inverted;
    int left;
    int top;
    int width;
    int height;
    int16_t cur_x;
    int16_t cur_y;
    bool pending_newline;
};

#endif
