#ifndef GAMBARSTATUS_H
#define GAMBARSTATUS_H

#ifdef __AVR__
 #include <avr/io.h>
 #include <avr/pgmspace.h>
#elif defined(ESP8266)
 #include <pgmspace.h>
#else
 #define PROGMEM
#endif


static const unsigned char gambarStatusBitmap[] PROGMEM = {
0x03, 0xc0, 0x04, 0x20, 0x08, 0x10, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x08, 0x10, 0x08, 0x10, 0x04, 0x20, 0x04, 0x20, 0x02, 0x40, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x01, 0x80, 
0x83, 0xc1, 0x47, 0xe2, 0x0f, 0xf0, 0x1f, 0xf8, 0xdf, 0xfb, 0x1f, 0xf8, 0x1f, 0xf8, 0x4f, 0xf2, 0x8f, 0xf1, 0x07, 0xe0, 0x07, 0xe0, 0x02, 0x40, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x01, 0x80, 
0x07, 0x00, 0x07, 0x00, 0x03, 0x00, 0x03, 0x00, 0x01, 0x00, 0x01, 0x06, 0x01, 0x1e, 0xff, 0xfe, 0xf1, 0x00, 0xc1, 0x00, 0x01, 0x00, 0x01, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x01, 0xc0, 0x00, 0x00, 
0x0f, 0x00, 0x1f, 0x00, 0x27, 0x08, 0x07, 0x04, 0x0b, 0x26, 0x03, 0x1e, 0x01, 0x7e, 0xff, 0xfe, 0xfd, 0x00, 0xf1, 0x80, 0xc9, 0xa0, 0x41, 0xc0, 0x21, 0xc8, 0x01, 0xf0, 0x01, 0xe0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03, 0x80, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 
0x01, 0x00, 0x11, 0x10, 0x11, 0x10, 0x09, 0x20, 0x09, 0x20, 0x05, 0x40, 0x44, 0x44, 0x32, 0x98, 0x0e, 0xe0, 0x01, 0x00, 0x01, 0x00, 0x03, 0x80, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 0x07, 0xc0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x03, 0x60, 0x06, 0x30, 0x04, 0x90, 0x06, 0x30, 0x03, 0x60, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x80, 0x00, 0x40, 0x03, 0xe0, 0x04, 0x00, 0x01, 0xc8, 0x13, 0x64, 0x36, 0x34, 0x54, 0x95, 0x16, 0x36, 0x13, 0x64, 0x09, 0xc0, 0x00, 0x10, 0x03, 0xe0, 0x01, 0x00, 0x00, 0x80, 
0x00, 0x00, 0xe0, 0x00, 0x73, 0x00, 0x39, 0x90, 0x1c, 0xc8, 0x0e, 0x64, 0x07, 0x32, 0x07, 0xb9, 0x07, 0x32, 0x0e, 0x64, 0x1c, 0xc8, 0x39, 0x90, 0x73, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xff, 0x00, 0xe1, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x87, 0x00, 0xff, 0x0e, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x0e, 0x00, 0x00, 0x00, 
};

const GFXglyph gambarStatusGlyphs[] PROGMEM = {
  {     0,  16,  16,  17,    0,    0 },
  {     32,  16,  16,  17,    0,    0 },
  {     64,  16,  16,  17,    0,    0 },
  {     96,  16,  16,  17,    0,    0 },
  {     128,  16,  16,  17,    0,    0 },
  {     160,  16,  16,  17,    0,    0 },
  {     192,  16,  16,  17,    0,    0 },
  {     224,  16,  16,  17,    0,    0 },
  {     256,  16,  16,  17,    0,    0 },
  {     288,  16,  16,  17,    0,    0 },
};
  
  
  const GFXfont gambarStatus PROGMEM = {
  (uint8_t  *)gambarStatusBitmap,
  (GFXglyph *)gambarStatusGlyphs,
  0, 10, 20 };
#endif
