#include <RTClib.h>

RTC_DS3231 rtc;
DateTime now;

char *hariStr2[7] = {"mg", "sn", "sl", "ra", "ka", "ju", "sa"};
char *hariStr3[7] = {"MIN", "SEN", "SEL", "RAB", "KAM", "JUM", "SAB"};
char *hariStr[7] = {"Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jum'at", "Sabtu"};

char *bulanStr3[12] = {"JAN", "FEB", "MAR", "APR", "MEI", "JUN", "JUL", "AGS", "SEP", "OKT", "NOP", "DES"};
char *bulanStrUpper[12] = {"JANUARI", "FEBRUARI", "MARET", "APRIL", "MEI", "JUNI", "JULI", "AGUSTUS", "SEPTEMBER", "OKTOBER", "NOVEMBER", "DESEMBER"};
char *bulanStr[12] = {"Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"};

char buffer[20];
byte detikSebelumnya = 60;
byte tanggalSebelumnya = 0;
uint32_t millisDetik;

void setup () {
  digitalWrite(13, LOW);
  pinMode(13, OUTPUT);
  pinMode(13, INPUT_PULLUP);

  Serial.begin(9600);

  if (! rtc.begin())
  {
    Serial.println(F("Couldn't find RTC"));
  }

  if (rtc.lostPower())
  {
    Serial.println(F("RTC lost power, let's set the time!"));
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
  }
  // rtc.adjust(DateTime(2021, 1, 1, 0, 0, 0));
}

void loop () {

  if (millisDetik < millis())
  {
    millisDetik = millis() + 100;
    now = rtc.now();

    if (tanggalSebelumnya != now.day())
    {
      tanggalSebelumnya = now.day();
    }

    if (detikSebelumnya != now.second())
    {
      detikSebelumnya = now.second();

      sprintf(buffer, "%s, %02d/%02d/%04d  ", hariStr[now.dayOfTheWeek()], now.day(), now.month(), now.year());
      Serial.println(buffer);
      sprintf(buffer, "%02d/%02d/%04d", now.day(), now.month(), now.year());
      Serial.println(buffer);
      sprintf(buffer, "%02d:%02d:%02d", now.hour(), now.minute(), now.second());
      Serial.println(buffer);
    }
  }
}
