<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		
		$this->load->dbforge();

		if (!$this->db->table_exists('data_parameter') )
		{
			$this->dbforge->add_field(array(
				'nomor' => array(
						'type' => 'INT',
						'constraint' => '11',
						'auto_increment' => TRUE
				),
				'waktu' => array(
						'type' => 'DATETIME'
				),
				'setSuhu' => array(
						'type' => 'VARCHAR',
						'null' => TRUE,
						'constraint' => '100'
				),
			));
			$this->dbforge->add_key('nomor', TRUE);

			$this->dbforge->create_table('data_parameter');			
		}

		if (!$this->db->table_exists('data_sensor') )
		{
			$this->dbforge->add_field(array(
				'nomor' => array(
						'type' => 'INT',
						'constraint' => '11',
						'auto_increment' => TRUE
				),
				'waktu' => array(
						'type' => 'DATETIME'
				),
				'api' => array(
						'type' => 'VARCHAR',
						'null' => TRUE,
						'constraint' => '100'
				),
				'asap' => array(
						'type' => 'VARCHAR',
						'null' => TRUE,
						'constraint' => '100'
				),
				'suhu' => array(
						'type' => 'VARCHAR',
						'null' => TRUE,
						'constraint' => '100'
				),
			));
			$this->dbforge->add_key('nomor', TRUE);

			$this->dbforge->create_table('data_sensor');			
		}

		$this->load->model('Model_databaseArduino');
		$data['dataSensor'] = $this->Model_databaseArduino->ambilDataDariArduino();
		$data['dataParameter'] = $this->Model_databaseArduino->ambilDataDariBrowser();
		$this->load->view('data_sensor', $data);
	}
}
